package com.bokesoft.yigo.mid.log;

import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class BPMLogArchive {
	/**
	 * 将指定日期之前的BPM日志归档到ES中
	 * @param context 上下文
	 * @param date 指定日期
	 * @param async 是否异步
	 * @throws Throwable 异常
	 */
	public void archiveByES(DefaultContext context, Date date, boolean async)throws Throwable{
		if (date == null) {
			LogSvr.getInstance().debug("given time is null, archive is refused..");
			return;
		}
		if (async) {
			ExecutorService service = Executors.newCachedThreadPool();
			service.execute(new Runnable() {
				@Override
				public void run() {
					ArchiveProxy proxy = new ArchiveProxy("es");
					try {
						proxy.archive(context, date);
					} catch (Throwable e) {
						e.printStackTrace();
					}
				}
			});
			service.shutdown();
		}else {
			ArchiveProxy proxy = new ArchiveProxy("es");
			proxy.archive(context, date);
		}
	}
	
	/**
	 * 将指定日期区间的BPM日志归档到ES中
	 * @param context 上下文
	 * @param start 开始日期
	 * @param end 结束日期
	 * @param async 是否异步
	 * @throws Throwable 异常
	 */
	public void archiveByES(DefaultContext context, Date start, Date end, boolean async)throws Throwable{
		
		if (start == null || end == null) {
			LogSvr.getInstance().debug("start or end time is null, archive is refused..");
			return;
		}
		
		if (async) {
			ExecutorService service = Executors.newCachedThreadPool();
			service.execute(new Runnable() {
				@Override
				public void run() {
					ArchiveProxy proxy = new ArchiveProxy("es");
					try {
						proxy.archive(context, start, end);
					} catch (Throwable e) {
						e.printStackTrace();
					}
				}
			});
			service.shutdown();
		}else {
			ArchiveProxy proxy = new ArchiveProxy("es");
			proxy.archive(context, start, end);
		}
	}
	
	public List<LogData> loadLogs(DefaultContext context, long instanceID) throws Throwable{
		return new ArchiveProxy("es").getLogs(context, instanceID);
	}
	
}
