package com.bokesoft.yigo.mid.form;

import java.io.InputStream;
import java.nio.charset.Charset;


import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.schema.DataObjectSchemaProvider;
import com.bokesoft.yes.mid.schema.ISchemaProvider;
import com.bokesoft.yes.mid.schema.maintance.DBMaintanceFactory;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.util.MD5Util;

public class AddDataObject {
	private String projectKey;
	private String objectKey;
	private int primaryType;
	private int secondaryType;
	private String objectText;
	private String filePath;
	
	public AddDataObject(String projectKey, String objectKey, int primaryType, int secondaryType, String objectText, String filePath) {
		super();
		this.projectKey = projectKey;
		this.objectKey = objectKey;
		this.primaryType = primaryType;
		this.secondaryType = secondaryType;
		this.objectText = objectText;
		this.filePath = filePath;
	}
	
	public void add(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaSolution metaSolution = metaFactory.getSolution();
				
		IMetaResolver resolver = metaFactory.getProjectResolver(projectKey);
		resolver.write(filePath, objectText.getBytes(Charset.forName("UTF-8")));
		
		MetaProject project = metaSolution.getProject(projectKey);
		MetaDataObjectProfile profile = new MetaDataObjectProfile();
		profile.setProject(project);
		profile.setKey(objectKey);
		profile.setPrimaryType(primaryType);
		profile.setSecondaryType(secondaryType);
		profile.setResource(filePath);
		
		metaFactory.getDataObjectList().add(profile);
		
		// MD5维护
		//获取md5的内容
		InputStream in = resolver.read(filePath, -1);
		String md5 = MD5Util.getMD5ByData(FileUtil.File2byte(in));
		
		String absolutePath = resolver.getPath(filePath);
		
		CoreSetting setting = CoreSetting.getInstance();
		String solutionPath = setting.getSolutionPath();
				
		String relativePath = absolutePath.substring(solutionPath.length() + 1);// 相对路径
		relativePath = relativePath.replaceAll("\\\\", "/");
				
		StringBuilder md5_msg = new StringBuilder();
		md5_msg.append(relativePath).append("*").append(md5).append("\n");
		
		//把md5写入solution目录下的Config.md5文件
		IMetaResolver metaResolver = metaFactory.getMetaResolverFactory().newMetaResolver("");
		metaResolver.write("Config.md5", md5_msg.toString().getBytes());
		
		MetaDataObject dataObject = metaFactory.getDataObject(objectKey);
		
		IDBManager dbManager = context.getDBManager();
		ISchemaProvider provider = new DataObjectSchemaProvider(dataObject);
		DBMaintanceFactory.getInstance().maintance(provider, dbManager);
	}
}
