package com.bokesoft.yigo.mid.event.types.meta.load.post;

import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.event.types.meta.load.MetaPostLoadEvent;

public class MetaDomainDefPostLoadEvent extends MetaPostLoadEvent<MetaDomainDef>{

	private final String solutionKey;
	
	private final MetaProject project;
	
	private final IMetaResolver resolver;
	
	public MetaDomainDefPostLoadEvent(IMetaFactory metaFactory, MetaDomainDef meta, String solutionKey,
			MetaProject project, IMetaResolver resolver) {
		super(metaFactory, meta);
		this.solutionKey = solutionKey;
		this.project = project;
		this.resolver = resolver;
	}

	public String getSolutionKey() {
		return solutionKey;
	}

	public MetaProject getProject() {
		return project;
	}

	public IMetaResolver getResolver() {
		return resolver;
	}
}
