package com.bokesoft.yigo.mid.event.types.meta.factory;

import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.mid.event.types.meta.MetaFactoryEvent;

/**
 * 加載Solution后事件
 *
 * @author wangfeng
 */
public class SolutionPostLoadEvent extends MetaFactoryEvent {
	/** 配置对象标识 */
	private final String solutionKey;

	/** 是否是主配置*/
	private final boolean isPrimary;

	public SolutionPostLoadEvent(IMetaFactory metaFactory, String solutionKey, boolean isPrimary) {
		super(metaFactory);
		this.solutionKey = solutionKey;
		this.isPrimary = isPrimary;
	}

	public String getSolutionKey() {
		return solutionKey;
	}

	public boolean isPrimary() {
		return isPrimary;
	}
}
