package com.bokesoft.yigo.mid.document.io;

import java.util.HashMap;
import java.util.Map;

import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.iosetting.MetaIOObject;
import com.bokesoft.yigo.meta.iosetting.MetaIOSetting;
import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * IO接口的总体工厂类
 * 
 * @author 刘翔翔
 *
 */
public class IOFactory {

	/** 扩展IO接口 */
	private static Map<String, DocumentIOFactory> factories = new HashMap<String, DocumentIOFactory>();

	/** 默认的DBIO接口 */
	private static DocumentIOFactory defaultIOFactory = new DefaultDocumentIOFactory();

	/**
	 * 获取访问单据数据的IO接口
	 * 
	 * @param context
	 *            上下文
	 * @return 文档IO对象
	 */
	public static final DocumentIO getDocumentIO(DefaultContext context) {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaDataObject metaDataObject = context.getDataObject();
		MetaIOSetting IOSetting = metaFactory.getIOSetting();
		if (metaDataObject != null && IOSetting != null) {
			String providerKey = "";
			if (metaDataObject.isProviderInit())
				providerKey = metaDataObject.getIOProvider();
			else {
				providerKey = metaDataObject.getIOProvider();
				if (providerKey == null || providerKey.isEmpty()) {
					MetaIOObject IOObject = IOSetting.getPersist().get(metaDataObject.getKey());
					if (IOObject != null)
						providerKey = IOObject.getProviderKey();

				}
				metaDataObject.setIOProvider(providerKey);
				metaDataObject.setProviderInit(true);
			}

			if (providerKey != null && !providerKey.isEmpty()) {
				DocumentIOFactory IOFactory = factories.get(providerKey);
				if (IOFactory != null)
					return IOFactory.newDocumentIO();
			}
		}

		return defaultIOFactory.newDocumentIO();
	}

	/**
	 * 注册扩展IO接口
	 * 
	 * @param key
	 * @param factory
	 */
	public static final void setDocumentIOFactory(String key, DocumentIOFactory factory) {
		factories.put(key, factory);
	}

}
