package com.bokesoft.yigo.mid.document.io;
import com.bokesoft.yes.mid.document.io.DocumentXMLIODeleteImpl;
import com.bokesoft.yes.mid.document.io.DocumentXMLIOLoadImpl;
import com.bokesoft.yes.mid.document.io.DocumentXMLIOSaveImpl;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.struct.document.SaveFilterMap;

public class DocumentXMLIO implements DocumentIO {
	
	@Override
	public Document save(DefaultContext context, SaveFilterMap saveFilterMap,
			Document document) throws Throwable {
		MetaDataObject metaDataObject = document.getMetaDataObject();
		DocumentXMLIOSaveImpl save = new DocumentXMLIOSaveImpl(this.key, metaDataObject);
		return save.save(context, document);
	}

	@Override
	public void delete(DefaultContext context, Document document)
			throws Throwable {
		DocumentXMLIODeleteImpl delete = new DocumentXMLIODeleteImpl(this.key, document.getMetaDataObject(), document);
		delete.delete(context);

	}

	@Override
	public Document load(DefaultContext context, MetaDataObject metaDataObject,
			Long OID) throws Throwable {
		FilterMap fm = new FilterMap();
		fm.setOID(OID);
		return load(context, null, metaDataObject, fm, null);
	}

	@Override
	public Document load(DefaultContext context, Document document,
			MetaDataObject metaDataObject, FilterMap filterMap,
			ConditionParas condParameters) throws Throwable {
		if (document == null)
			document = new Document(metaDataObject, filterMap.getOID());
		DocumentXMLIOLoadImpl load = new DocumentXMLIOLoadImpl(this.key, metaDataObject);
		load.load(context, document);
		return document;
	}

	/** IO的标识 */
	private String key = "xml";
	@Override
	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public void setDataSource(MetaDataSource dataSource) {
	}

}
