package com.bokesoft.yigo.mid.document.io;

import com.bokesoft.yes.mid.document.io.DocumentDBIOSaveImpl;
import com.bokesoft.yes.mid.document.io.DocumentDBIOLoadImpl;
import com.bokesoft.yes.mid.document.io.DocumentDBIODeleteImpl;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.struct.document.SaveFilterMap;

public class DocumentDBIO implements DocumentIO {

	@Override
	public Document save(DefaultContext context, SaveFilterMap saveFilterMap, Document document) throws Throwable {
		MetaDataObject metaDataObject = document.getMetaDataObject();
		DocumentDBIOSaveImpl save = new DocumentDBIOSaveImpl(
				this.dataSource, metaDataObject, saveFilterMap);
		return save.save(context, document);
	}

	@Override
	public void delete(DefaultContext context, Document document) throws Throwable {
		DocumentDBIODeleteImpl delete = new DocumentDBIODeleteImpl(
				this.dataSource, document.getMetaDataObject(), document);
		delete.delete(context);
	}

	@Override
	public Document load(DefaultContext context, MetaDataObject metaDataObject, Long OID) throws Throwable {
		FilterMap fm = new FilterMap();
		fm.setOID(TypeConvertor.toLong(OID));
		return load(context, null, metaDataObject, fm, null);
	}

	@Override
	public Document load(DefaultContext context, Document document, MetaDataObject metaDataObject, FilterMap filterMap, ConditionParas condParameters) throws Throwable {
		if (document == null)
			document = new Document(metaDataObject, filterMap.getOID());
		DocumentDBIOLoadImpl load = new DocumentDBIOLoadImpl(
				this.dataSource, metaDataObject, filterMap, condParameters);
		load.load(context, document);
		return document;
	}

	/** IO的标识 */
	@SuppressWarnings("unused")
	private String key = "";
	@Override
	public void setKey(String key) {
		this.key = key;
	}

	private MetaDataSource dataSource = null;
	@Override
	public void setDataSource(MetaDataSource dataSource) {
		this.dataSource = dataSource;
	}
}