package com.bokesoft.yigo.mid.document;

import com.bokesoft.yes.mid.util.SequenceSeed;
import com.bokesoft.yigo.common.def.GrantIDType;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.oid.IOIDAllocator;
import com.bokesoft.yigo.mid.util.GrantID;

public class OIDAllocator implements IOIDAllocator {
	DefaultContext context = null;

	public OIDAllocator(DefaultContext context) {
		this.context = context;
	}

	@Override
	public long applyNewOID() throws Throwable {
		return GrantID.applyID(context, GrantIDType.OID);
	}

	@Override
	public int applyNewSequenceID(String dataObjectKey, String NoPrefix) throws Throwable {
		return applyNewSequenceID(dataObjectKey, NoPrefix, context.getFormKey());
	}


	@Override
	public int applyNewSequenceID(String dataObjectKey, String NoPrefix, String tag) throws Throwable {
		return SequenceSeed.applyNewID(context, dataObjectKey, NoPrefix, tag);
	}

	@Override
	public long applyNewOID(int type) throws Throwable {
		return GrantID.applyID(context, type);
	}

	@Override
	public long applyNewInterval(int type, long interval) throws Throwable {
		return GrantID.applyNewInterval(context, type, interval);
	}

}