package com.bokesoft.yigo.mid.document;

import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.FilterMap;

/**
 * LoadFormData为载入数据的入口类，其通过表单的标识载入表单的关联数据
 * 
 * @author 王元和
 *
 */
public class LoadFormData extends LoadData {
	/** 表单标识 */
	private String formKey = null;
	
	private String templateKey = null;
	
	public LoadFormData(String formKey, FilterMap filterMap, ConditionParas condParameters) {
		super();
		this.filterMap = filterMap;
		this.condParameters = condParameters;
		this.formKey = formKey;
	}

	public LoadFormData(String formKey, FilterMap filterMap, ConditionParas condParameters, String templateKey) {
		super();
		this.filterMap = filterMap;
		this.condParameters = condParameters;
		this.formKey = formKey;
		this.templateKey = templateKey;
	}
	
	public LoadFormData(String formKey, long OID) {
		super();
		filterMap = new FilterMap();
		filterMap.setOID(OID);
		this.formKey = formKey;
	}

	protected MetaDataObject getDataObjectKey(DefaultContext context) throws Throwable {
		context.setFormKey(formKey);
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		
		MetaForm metaForm = null;
		if(templateKey != null && !templateKey.isEmpty()){
			metaForm = metaFactory.getMetaForm(formKey, templateKey);
		}else{
			metaForm = metaFactory.getMetaForm(formKey);
		}

		MetaDataObject metaDataObject = null;
		String refDataObjectKey = metaForm.getDataSource().getRefObjectKey();
		if (refDataObjectKey != null && refDataObjectKey.length() > 0) {
			metaDataObject = metaFactory.getDataObject(refDataObjectKey);
		}
		
		filterMap.setOIDFilter(metaForm.getDataSource().getOIDFilter());

		if (metaDataObject == null) {
			metaDataObject = metaForm.getDataSource().getDataObject();
		}
		
		

		return metaDataObject;
	}
}
