package com.bokesoft.yigo.mid.document;

import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.io.DocumentIO;
import com.bokesoft.yigo.mid.document.io.IOFactory;
import com.bokesoft.yigo.struct.document.Document;

public class LoadDataDirect {

	private String objectKey;

	private Long OID;

	public LoadDataDirect(String objectKey, Long OID) {
		this.objectKey = objectKey;
		this.OID = OID;
	}

	public Document load(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaDataObject metaDataObject = metaFactory.getDataObject(objectKey);

		DocumentIO ioFactory = IOFactory.getDocumentIO(context);
		return ioFactory.load(context, metaDataObject, OID);

	}
}
