package com.bokesoft.yigo.mid.dict.io;

import com.bokesoft.yes.mid.dict.io.DictDBIOFactory;
import com.bokesoft.yigo.tools.ve.VE;

/**
 * 字典读写类工厂
 */
public class DictIOFactory {
	
	private IDictIOFactory factory = null;
	
	private static DictIOFactory INSTANCE = null;
	
	public static DictIOFactory getInstance() {
		if(INSTANCE == null){
			INSTANCE = new DictIOFactory();
		}
		return INSTANCE;
	}
	
	/**
	 * 设置字典读写工厂
	 * @param factory 字典读写工厂
	 */
	public void setFactory(IDictIOFactory factory){
		this.factory = factory;
	}
	
	/**
	 * 获取字典读写类
	 * @param ve 环境变量
	 * @param itemKey 字典标识
	 * @return 字典读写类
	 */
	public IDictIO createDictIO(VE ve, String itemKey){
		if(this.factory == null){
			this.factory = new DictDBIOFactory();
		}
		return this.factory.createDictIO(ve, itemKey);
	}
}
