/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.entry;

import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericCompositeCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;
import java.util.Iterator;
import java.util.LinkedList;

public class MetaEntry
extends GenericCompositeCollection {
    private String key = "";
    private String caption = "";
    private String captionEn = "";
    private Boolean isOpen = false;
    private String visible = "";
    private String icon = "";
    private String iconCode;
    private String project = null;
    private MetaBaseScript onClick = null;
    private int style = 2;
    private String path = "";
    public static final String TAG_NAME = "Entry";

    @Override
    public int getCompositeType() {
        return 1;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        this.addAll(list, new Object[]{this.onClick});
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject resultMetaObject = null;
        if ("EntryItem".equals(tagName)) {
            MetaEntryItem metaEntryItem = new MetaEntryItem();
            this.add(metaEntryItem);
            resultMetaObject = metaEntryItem;
        } else if (TAG_NAME.equals(tagName)) {
            MetaEntry metaEntry = new MetaEntry();
            this.add(metaEntry);
            resultMetaObject = metaEntry;
        } else if (tagName.equals("OnClick")) {
            this.onClick = new MetaBaseScript("OnClick");
            resultMetaObject = this.onClick;
        }
        return resultMetaObject;
    }

    public MetaBaseScript getOnClick() {
        return this.onClick;
    }

    public void setOnClick(MetaBaseScript onClick) {
        this.onClick = onClick;
    }

    public void setOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Boolean isOpen() {
        return this.isOpen;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaptionEn(String captionEn) {
        this.captionEn = captionEn;
    }

    public String getCaptionEn() {
        return this.captionEn;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setVisible(String visible) {
        this.visible = visible;
    }

    public String getVisible() {
        return this.visible;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getStyle() {
        return this.style;
    }

    public String getIconCode() {
        return this.iconCode;
    }

    public void setIconCode(String iconCode) {
        this.iconCode = iconCode;
    }

    public void setProject(String project) {
        this.project = project;
        this.setEntryProject(this, project);
    }

    public void setEntryProject(MetaEntry meta, String project) {
        MetaEntry entry = null;
        MetaEntryItem entryItem = null;
        AbstractCompositeObject obj = null;
        int size = meta.size();
        for (int i = 0; i < size; ++i) {
            obj = meta.get(i);
            if (obj instanceof MetaEntry) {
                entry = (MetaEntry)obj;
                entry.setProject(project);
                if (entry.size() <= 0) continue;
                this.setEntryProject(entry, project);
                continue;
            }
            if (!(obj instanceof MetaEntryItem)) continue;
            entryItem = (MetaEntryItem)obj;
            entryItem.setProject(project);
        }
    }

    public String getProject() {
        return this.project;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaEntry newObject = (MetaEntry)super.clone();
        newObject.setKey(this.key);
        newObject.setCaption(this.caption);
        newObject.setCaptionEn(this.captionEn);
        newObject.setOpen(this.isOpen);
        newObject.setIcon(this.icon);
        newObject.setStyle(this.style);
        newObject.setVisible(this.visible);
        newObject.setProject(this.project);
        newObject.setPath(this.path);
        newObject.setIconCode(this.iconCode);
        newObject.setOnClick(this.onClick == null ? null : (MetaBaseScript)this.onClick.clone());
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaEntry();
    }

    public void merge(MetaEntry source) {
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            this.add(source.get(i));
        }
    }

    public AbstractCompositeObject findBy(String key) {
        Iterator<AbstractCompositeObject> iter = this.iterator();
        AbstractCompositeObject object = null;
        while (iter.hasNext()) {
            MetaEntryItem metaEntryItem;
            object = iter.next();
            if (object.getCompositeType() == 1) {
                MetaEntry metaEntry = (MetaEntry)object;
                if (key.equalsIgnoreCase(metaEntry.getKey())) {
                    return metaEntry;
                }
                AbstractCompositeObject obj = metaEntry.findBy(key);
                if (obj == null) continue;
                return obj;
            }
            if (object.getCompositeType() != 0 || !key.equalsIgnoreCase((metaEntryItem = (MetaEntryItem)object).getKey())) continue;
            return metaEntryItem;
        }
        return null;
    }

    public AbstractCompositeObject findChild(String key) {
        Iterator<AbstractCompositeObject> iter = this.iterator();
        AbstractCompositeObject object = null;
        while (iter.hasNext()) {
            MetaEntryItem metaEntryItem;
            object = iter.next();
            if (object.getCompositeType() == 1) {
                MetaEntry metaEntry = (MetaEntry)object;
                if (!key.equalsIgnoreCase(metaEntry.getKey())) continue;
                return metaEntry;
            }
            if (object.getCompositeType() != 0 || !key.equalsIgnoreCase((metaEntryItem = (MetaEntryItem)object).getKey())) continue;
            return metaEntryItem;
        }
        return null;
    }

    public void removeBy(AbstractCompositeObject obj) {
        Iterator<AbstractCompositeObject> iter = this.iterator();
        AbstractCompositeObject object = null;
        while (iter.hasNext()) {
            MetaEntryItem metaEntryItem;
            object = iter.next();
            if (object.getCompositeType() == 1) {
                MetaEntry metaEntry = (MetaEntry)object;
                if (metaEntry == obj) {
                    this.remove(obj);
                    return;
                }
                metaEntry.remove(obj);
                continue;
            }
            if (object.getCompositeType() != 0 || (metaEntryItem = (MetaEntryItem)object) != obj) continue;
            this.remove(obj);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

