/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaAddCollection;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaDeleteCollection;
import com.bokesoft.yigo.meta.diff.MetaDiffNodeCollection;
import com.bokesoft.yigo.meta.diff.MetaMove;
import com.bokesoft.yigo.meta.diff.MetaMoveCollection;
import com.bokesoft.yigo.meta.diff.MetaUpdateCollection;
import com.bokesoft.yigo.meta.diff.impl.IMergeDiffAction;
import com.bokesoft.yigo.meta.diff.util.DiffActionManager;
import com.bokesoft.yigo.meta.diff.util.DiffKeyUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MetaDiffNode
extends KeyPairMetaObject {
    public static final String TAG_NAME = "DiffNode";
    private String key = null;
    private MetaAddCollection addCollection = null;
    private MetaDeleteCollection deleteCollection = null;
    private MetaUpdateCollection updateCollection = null;
    private MetaMoveCollection moveCollection = null;
    private MetaDiffNodeCollection childDiffNodeCollection = null;
    private AbstractMetaObject meta = null;
    private boolean isChanged = false;
    private List<String> deleteAttrs = null;

    public MetaDiffNode() {
        this.deleteAttrs = new ArrayList<String>();
    }

    public MetaDiffNode(String baseKey, AbstractMetaObject meta, AbstractMetaObject parent, AbstractMetaObject grandParent) {
        this.meta = meta;
        this.deleteAttrs = new ArrayList<String>();
        this.setKey(DiffKeyUtil.getDiffKey(baseKey, meta, parent, grandParent));
    }

    public void setDeleteAttrs(String deleteAttrs) {
        this.deleteAttrs.clear();
        if (!StringUtil.isBlankOrNull((String)deleteAttrs)) {
            String[] attrNames;
            for (String attrName : attrNames = StringUtil.split((String)deleteAttrs, (String)"|")) {
                this.deleteAttrs.add(attrName);
            }
        }
    }

    public String getDeleteAttrs() {
        return StringUtil.join((String)"|", this.deleteAttrs.iterator());
    }

    public List<String> getDeleteAttrList() {
        return this.deleteAttrs;
    }

    public void addDeleteAttr(String attrName) {
        this.deleteAttrs.add(attrName);
    }

    public boolean isDeleteAttr(String attrName) {
        return this.deleteAttrs.contains(attrName);
    }

    public void removeDeleteAttr(String attrName) {
        this.deleteAttrs.remove(attrName);
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void markChanged() {
        this.isChanged = true;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public AbstractMetaObject getMeta() {
        return this.meta;
    }

    public void recordAdd(String key, String previousKey, String containerTag, String containerKey, AbstractMetaObject child) {
        if (this.addCollection == null) {
            this.addCollection = new MetaAddCollection();
        }
        MetaAdd metaAdd = new MetaAdd(key);
        metaAdd.setContainerKey(containerKey);
        metaAdd.setContainerTag(containerTag);
        metaAdd.setPreviousKey(previousKey);
        metaAdd.setBase(child);
        this.addCollection.add(metaAdd);
        this.markChanged();
    }

    public void recordAdd(KeyPairMetaObject child) {
        this.recordAdd(child.getKey(), "", "", "", child);
    }

    public void recordDelete(String key, AbstractMetaObject meta, AbstractMetaObject parentMeta) {
        if (this.deleteCollection == null) {
            this.deleteCollection = new MetaDeleteCollection();
        }
        String parentTag = parentMeta == null ? "" : parentMeta.getTagName();
        this.deleteCollection.add(new MetaDelete(key, meta.getTagName(), parentTag));
        this.markChanged();
    }

    public void recordDelete(KeyPairMetaObject meta, AbstractMetaObject parentMeta) {
        this.recordDelete(meta.getKey(), meta, parentMeta);
    }

    public void recordMove(MetaMove move) {
        if (this.moveCollection == null) {
            this.moveCollection = new MetaMoveCollection();
        }
        this.moveCollection.add(move);
        this.markChanged();
    }

    public void addDiffNode(MetaDiffNode diffNode) {
        if (diffNode.isChanged) {
            if (this.childDiffNodeCollection == null) {
                this.childDiffNodeCollection = new MetaDiffNodeCollection();
            }
            this.childDiffNodeCollection.add(diffNode);
        }
    }

    public void recordUpdate(AbstractMetaObject item) {
        if (this.updateCollection == null) {
            this.updateCollection = new MetaUpdateCollection();
        }
        this.updateCollection.add(item);
        this.markChanged();
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        list.add(this.meta);
        list.add(this.addCollection);
        list.add(this.updateCollection);
        list.add(this.deleteCollection);
        list.add(this.moveCollection);
        list.add(this.childDiffNodeCollection);
    }

    public void setAddCollection(MetaAddCollection addCollection) {
        this.addCollection = addCollection;
    }

    public void setUpdateCollection(MetaUpdateCollection updateCollection) {
        this.updateCollection = updateCollection;
    }

    public void setDeleteCollection(MetaDeleteCollection deleteCollection) {
        this.deleteCollection = deleteCollection;
    }

    public void setMoveCollection(MetaMoveCollection moveCollection) {
        this.moveCollection = moveCollection;
    }

    private void setChildDiffNodeCollection(MetaDiffNodeCollection childDiffNodeCollection) {
        this.childDiffNodeCollection = childDiffNodeCollection;
    }

    public void setBase(AbstractMetaObject meta) {
        this.meta = meta;
    }

    public AbstractMetaObject getBase() {
        return this.meta;
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject metaObject = null;
        if ("AddCollection".equalsIgnoreCase(tagName)) {
            metaObject = this.addCollection = new MetaAddCollection();
        } else if ("UpdateCollection".equalsIgnoreCase(tagName)) {
            this.updateCollection = new MetaUpdateCollection();
            metaObject = this.updateCollection;
        } else if ("DeleteCollection".equalsIgnoreCase(tagName)) {
            this.deleteCollection = new MetaDeleteCollection();
            metaObject = this.deleteCollection;
        } else if ("MoveCollection".equalsIgnoreCase(tagName)) {
            this.moveCollection = new MetaMoveCollection();
            metaObject = this.moveCollection;
        } else if ("DiffNodeCollection".equalsIgnoreCase(tagName)) {
            this.childDiffNodeCollection = new MetaDiffNodeCollection();
            metaObject = this.childDiffNodeCollection;
        } else {
            this.meta = DiffActionManager.getInstance().createMetaElement(tagName, env);
            this.meta.preProcessMetaObject(env, doc, node, flag, runType);
            metaObject = this.meta;
        }
        return metaObject;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaDiffNode clone = new MetaDiffNode();
        clone.setAddCollection(this.addCollection == null ? null : (MetaAddCollection)this.addCollection.clone());
        clone.setUpdateCollection(this.updateCollection == null ? null : (MetaUpdateCollection)this.updateCollection.clone());
        clone.setDeleteCollection(this.deleteCollection == null ? null : (MetaDeleteCollection)this.deleteCollection.clone());
        clone.setMoveCollection(this.moveCollection == null ? null : (MetaMoveCollection)this.moveCollection.clone());
        clone.setChildDiffNodeCollection(this.childDiffNodeCollection == null ? null : (MetaDiffNodeCollection)this.childDiffNodeCollection.clone());
        clone.setBase((KeyPairMetaObject)this.meta.clone());
        return clone;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaDiffNode();
    }

    public void mergeDiff(IMergeDiffAction mergeAction) throws Exception {
        boolean result;
        mergeAction.mergeBase(this.meta);
        if (this.updateCollection != null) {
            for (AbstractMetaObject meta : this.updateCollection) {
                mergeAction.mergeUpdate(meta);
            }
        }
        if (this.deleteCollection != null) {
            for (AbstractMetaObject meta : this.deleteCollection) {
                mergeAction.mergeDelete((MetaDelete)meta);
            }
        }
        if (this.addCollection != null) {
            for (AbstractMetaObject meta : this.addCollection) {
                mergeAction.mergeAdd((MetaAdd)meta);
            }
        }
        if (this.moveCollection != null && !(result = mergeAction.mergeMoveCollection(this.moveCollection))) {
            for (MetaMove meta : this.moveCollection) {
                mergeAction.mergeMove(meta);
            }
        }
    }
}

