/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.dataobject;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaStatement;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.dataobject.MetaTableFilter;
import com.bokesoft.yigo.meta.dataobject.MetaTableSourceCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaIndexCollection;
import com.bokesoft.yigo.meta.solution.MetaLangConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MetaTable
extends GenericKeyCollectionWithKey<MetaColumn>
implements IPropertyMerger<MetaTable> {
    private static final long serialVersionUID = 1L;
    private String key = "";
    private String caption = "";
    private String dbTableName = "";
    private Integer tableMode = 0;
    private Integer sourceType = 0;
    private Boolean persist = true;
    private MetaStatement statement = null;
    private String formula = "";
    private String impl = "";
    private String parentKey = "";
    private Boolean hidden = false;
    private Boolean uniquePrimary = false;
    private MetaTableFilter filter = null;
    private MetaIndexCollection indexCollection = null;
    private Boolean loadInMidUse = true;
    private String indexPrefix = "";
    private String primaryKey = "";
    private Boolean refreshFilter = false;
    private Boolean lazyLoad = false;
    private String tempIndexPrefix = null;
    private MetaColumn OID = null;
    private MetaColumn SOID = null;
    private MetaColumn POID = null;
    private MetaColumn VERID = null;
    private MetaColumn DVERID = null;
    private MetaColumn STATUS = null;
    private MetaColumn INSTANCEID = null;
    private MetaColumn CLUSTERID = null;
    private MetaColumn MAPKEY = null;
    private MetaColumn NO = null;
    private MetaColumn BILLDATE = null;
    private MetaColumn CREATETIME = null;
    private MetaColumn LAYER = null;
    private MetaColumn HIDDEN = null;
    private MetaColumn SEQUENCE = null;
    private MetaColumn CREATOR = null;
    private MetaColumn MODIFIER = null;
    private MetaColumn MODIFYTIME = null;
    private MetaColumn CHECKER = null;
    private MetaColumn CHECKERTIME = null;
    private MetaColumn SrcOID = null;
    private MetaColumn SrcSOID = null;
    private MetaColumn MapCount = null;
    private MetaColumn SVERID = null;
    private MetaColumn SUBMITTER = null;
    private MetaColumn CODE = null;
    private MetaColumn SrcLangOID = null;
    private MetaColumn LastModified = null;
    private MetaColumn CreateDate = null;
    private String hisTableName = "";
    private int levelID = -1;
    private MetaParameterCollection parameterCollection = null;
    private MetaTableSourceCollection sourceCollection = null;
    private List<MetaColumn> sortColumns = null;
    private String orderBy = "";
    private String groupBy = "";
    private boolean useCursor = false;
    private String convertor = "";
    private boolean autoGen = false;
    private boolean T = false;
    public static final String _T = "_T";
    public static final String TAG_NAME = "Table";

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        this.addAll(list, new Object[]{this.filter, this.parameterCollection, this.sourceCollection, this.statement, this.indexCollection});
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject resultMetaObject = null;
        if ("Column".equals(tagName)) {
            resultMetaObject = new MetaColumn();
            resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
            this.add(resultMetaObject);
        } else if ("ParameterCollection".equals(tagName)) {
            this.parameterCollection = new MetaParameterCollection();
            resultMetaObject = this.parameterCollection;
        } else if ("Statement".equals(tagName)) {
            this.statement = new MetaStatement();
            resultMetaObject = this.statement;
        } else if ("TableSourceCollection".equals(tagName)) {
            this.sourceCollection = new MetaTableSourceCollection();
            resultMetaObject = this.sourceCollection;
        } else if ("TableFilter".equals(tagName)) {
            this.filter = new MetaTableFilter();
            resultMetaObject = this.filter;
        } else if ("IndexCollection".equals(tagName)) {
            this.indexCollection = new MetaIndexCollection();
            resultMetaObject = this.indexCollection;
        }
        return resultMetaObject;
    }

    public String getCaption() {
        return this.caption;
    }

    public Integer getTableMode() {
        return this.tableMode;
    }

    public Integer getSourceType() {
        return this.sourceType;
    }

    public boolean isHead() {
        return this.tableMode == 0;
    }

    public Boolean isPersist() {
        return this.persist;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setTableMode(Integer tableMode) {
        this.tableMode = tableMode;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public void setPersist(Boolean persist) {
        this.persist = persist;
    }

    public void setDBTableName(String dbTableName) {
        this.dbTableName = dbTableName;
    }

    public String getDBTableName() {
        return this.dbTableName;
    }

    public String getBindingDBTableName() {
        return this.dbTableName != null && !this.dbTableName.isEmpty() ? this.dbTableName : this.key;
    }

    public String getHistoryTableName() {
        return this.hisTableName != null && !this.hisTableName.isEmpty() ? this.hisTableName : this.getBindingDBTableName() + "_HIS";
    }

    public String getStringStatement() {
        return this.statement != null ? this.statement.getContent() : null;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setImpl(String impl) {
        this.impl = impl;
    }

    public String getImpl() {
        return this.impl;
    }

    public MetaStatement getStatement() {
        return this.statement;
    }

    public void setStatement(MetaStatement statement) {
        this.statement = statement;
    }

    public MetaTableFilter getFilter() {
        return this.filter;
    }

    public void setFilter(MetaTableFilter filter) {
        this.filter = filter;
    }

    public List<MetaColumn> getSortColumns() {
        if (this.sortColumns == null) {
            ArrayList<MetaColumn> tempList = new ArrayList<MetaColumn>();
            for (MetaColumn col : this) {
                if (col.getSort() == 0) continue;
                tempList.add(col);
            }
            this.sortColumns = tempList;
        }
        return this.sortColumns;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(String parentKey) {
        this.parentKey = parentKey;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean isHidden() {
        return this.hidden;
    }

    public void setUniquePrimary(Boolean uniquePrimary) {
        this.uniquePrimary = uniquePrimary;
    }

    public Boolean isUniquePrimary() {
        return this.uniquePrimary;
    }

    public Boolean isLoadInMidUse() {
        return this.loadInMidUse;
    }

    public void setLoadInMidUse(Boolean loadInMidUse) {
        this.loadInMidUse = loadInMidUse;
    }

    public Boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(Boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
    }

    public void setSourceCollection(MetaTableSourceCollection sourceCollection) {
        this.sourceCollection = sourceCollection;
    }

    public MetaTableSourceCollection getSourceCollection() {
        return this.sourceCollection;
    }

    public MetaIndexCollection getIndexCollection() {
        return this.indexCollection;
    }

    public void setIndexCollection(MetaIndexCollection indexCollection) {
        this.indexCollection = indexCollection;
    }

    public MetaColumn getOIDColumn() {
        if (this.OID != null) {
            return this.OID;
        }
        return (MetaColumn)this.get("OID");
    }

    public MetaColumn getSOIDColumn() {
        return this.SOID;
    }

    public MetaColumn getPOIDColumn() {
        return this.POID;
    }

    public MetaColumn getVERIDColumn() {
        return this.VERID;
    }

    public MetaColumn getDVERIDColumn() {
        return this.DVERID;
    }

    public MetaColumn getSTATUSColumn() {
        return this.STATUS;
    }

    public MetaColumn getINSTANCEIDColumn() {
        return this.INSTANCEID;
    }

    public MetaColumn getCLUSTERIDColumn() {
        return this.CLUSTERID;
    }

    public MetaColumn getMAPKEYColumn() {
        return this.MAPKEY;
    }

    public MetaColumn getNOColumn() {
        return this.NO;
    }

    public MetaColumn getBILLDATEColumn() {
        return this.BILLDATE;
    }

    public MetaColumn getCREATETIMEColumn() {
        return this.CREATETIME;
    }

    public MetaColumn getLayerColumn() {
        return this.LAYER;
    }

    public MetaColumn getHiddenColumn() {
        return this.HIDDEN;
    }

    public MetaColumn getSequenceColumn() {
        return this.SEQUENCE;
    }

    public MetaColumn getCreatorColumn() {
        return this.CREATOR;
    }

    public MetaColumn getModifierColumn() {
        return this.MODIFIER;
    }

    public MetaColumn getModifytimeColumn() {
        return this.MODIFYTIME;
    }

    public MetaColumn getCHECKER() {
        return this.CHECKER;
    }

    public MetaColumn getCHECKERTIME() {
        return this.CHECKERTIME;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public MetaColumn getSrcOIDColumn() {
        return this.SrcOID;
    }

    public MetaColumn getSrcSOIDColumn() {
        return this.SrcSOID;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public MetaColumn getLastModifiedColumn() {
        return this.LastModified;
    }

    public void setUseCursor(boolean useCursor) {
        this.useCursor = useCursor;
    }

    public boolean isUseCursor() {
        return this.useCursor;
    }

    public void setRefreshFilter(Boolean refreshFilter) {
        this.refreshFilter = refreshFilter;
    }

    public Boolean isRefreshFilter() {
        return this.refreshFilter;
    }

    public void setConvertor(String convertor) {
        this.convertor = convertor;
    }

    public String getConvertor() {
        return this.convertor;
    }

    public void setAutoGen(boolean autoGen) {
        this.autoGen = autoGen;
    }

    @Override
    public boolean isAutoGen() {
        return this.autoGen;
    }

    public boolean isT() {
        return this.T;
    }

    public void setT(boolean t) {
        this.T = t;
    }

    private void reset() {
        if (this.OID != null) {
            this.OID.setSystemControlField(false);
            this.OID = null;
        }
        if (this.SOID != null) {
            this.SOID.setSystemControlField(false);
            this.SOID = null;
        }
        if (this.POID != null) {
            this.POID.setSystemControlField(false);
            this.POID = null;
        }
        if (this.VERID != null) {
            this.VERID.setSystemControlField(false);
            this.VERID = null;
        }
        if (this.DVERID != null) {
            this.DVERID.setSystemControlField(false);
            this.DVERID = null;
        }
        if (this.MAPKEY != null) {
            this.MAPKEY.setSystemControlField(false);
            this.MAPKEY = null;
        }
        if (this.NO != null) {
            this.NO.setSystemControlField(false);
            this.NO = null;
        }
        this.STATUS = null;
        this.INSTANCEID = null;
        this.CLUSTERID = null;
        this.CREATETIME = null;
        this.BILLDATE = null;
        this.LAYER = null;
        this.HIDDEN = null;
        this.SEQUENCE = null;
        this.CREATOR = null;
        this.MODIFIER = null;
        this.MODIFYTIME = null;
        this.SrcOID = null;
        this.SrcSOID = null;
        this.MapCount = null;
        this.CHECKER = null;
        this.CHECKERTIME = null;
        this.SVERID = null;
        this.SUBMITTER = null;
        this.CODE = null;
        this.SrcLangOID = null;
        this.LastModified = null;
        this.CreateDate = null;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        this.reset();
        LinkedList autoGenColumnList = new LinkedList();
        this.forEach(metaColumn -> {
            String codeColumnKey;
            MetaColumn codeColumn;
            String key = metaColumn.getKey();
            if ("OID".equalsIgnoreCase(key)) {
                this.OID = metaColumn;
                metaColumn.setSystemControlField(true);
            } else if ("SOID".equalsIgnoreCase(key)) {
                this.SOID = metaColumn;
                metaColumn.setSystemControlField(true);
            } else if ("POID".equalsIgnoreCase(key)) {
                this.POID = metaColumn;
                metaColumn.setSystemControlField(true);
            } else if ("VERID".equalsIgnoreCase(key)) {
                this.VERID = metaColumn;
                metaColumn.setSystemControlField(true);
            } else if ("DVERID".equalsIgnoreCase(key)) {
                this.DVERID = metaColumn;
                metaColumn.setSystemControlField(true);
            } else if ("Status".equalsIgnoreCase(key)) {
                this.STATUS = metaColumn;
            } else if ("InstanceID".equalsIgnoreCase(key)) {
                this.INSTANCEID = metaColumn;
            } else if ("ClusterID".equalsIgnoreCase(key)) {
                this.CLUSTERID = metaColumn;
            } else if ("MapKey".equalsIgnoreCase(key)) {
                this.MAPKEY = metaColumn;
                metaColumn.setSystemControlField(true);
            } else if ("NO".equalsIgnoreCase(key)) {
                this.NO = metaColumn;
                metaColumn.setSystemControlField(true);
            } else if ("CreateTime".equalsIgnoreCase(key)) {
                this.CREATETIME = metaColumn;
            } else if ("BillDate".equalsIgnoreCase(key)) {
                this.BILLDATE = metaColumn;
            } else if ("Layer".equalsIgnoreCase(key)) {
                this.LAYER = metaColumn;
            } else if ("Hidden".equalsIgnoreCase(key)) {
                this.HIDDEN = metaColumn;
            } else if ("Sequence".equalsIgnoreCase(key)) {
                this.SEQUENCE = metaColumn;
            } else if ("Creator".equalsIgnoreCase(key)) {
                this.CREATOR = metaColumn;
            } else if ("Modifier".equalsIgnoreCase(key)) {
                this.MODIFIER = metaColumn;
            } else if ("ModifyTime".equalsIgnoreCase(key)) {
                this.MODIFYTIME = metaColumn;
            } else if ("SrcOID".equalsIgnoreCase(key)) {
                this.SrcOID = metaColumn;
            } else if ("SrcSOID".equalsIgnoreCase(key)) {
                this.SrcSOID = metaColumn;
            } else if ("MapCount".equalsIgnoreCase(key)) {
                this.MapCount = metaColumn;
            } else if ("Checker".equalsIgnoreCase(key)) {
                this.CHECKER = metaColumn;
            } else if ("CheckerTime".equalsIgnoreCase(key)) {
                this.CHECKERTIME = metaColumn;
            } else if ("SVERID".equalsIgnoreCase(key)) {
                this.SVERID = metaColumn;
            } else if ("Submitter".equalsIgnoreCase(key)) {
                this.SUBMITTER = metaColumn;
            } else if ("Code".equalsIgnoreCase(key)) {
                this.CODE = metaColumn;
            } else if ("SrcLangOID".equalsIgnoreCase(key)) {
                this.SrcLangOID = metaColumn;
            } else if ("LastModified".equalsIgnoreCase(key)) {
                this.LastModified = metaColumn;
            } else if ("CreateDate".equalsIgnoreCase(key)) {
                this.CreateDate = metaColumn;
            }
            if (metaColumn.isAccessControl().booleanValue()) {
                MetaColumn ctrlColumn = new MetaColumn();
                ctrlColumn.setKey(metaColumn.getKey() + "_CF");
                ctrlColumn.setDataType(1001);
                ctrlColumn.setDefaultValue("0");
                ctrlColumn.setPersist(true);
                autoGenColumnList.add(ctrlColumn);
            }
            if (metaColumn.getSplitType() == 0) {
                String beginColumn = metaColumn.getKey() + "_begin";
                String endColumn = metaColumn.getKey() + "_end";
                MetaColumn ctrlColumn = new MetaColumn();
                ctrlColumn.setKey(beginColumn);
                ctrlColumn.setCaption(metaColumn.getCaption() + "_\u671f\u521d");
                ctrlColumn.setDataType(metaColumn.getDataType());
                ctrlColumn.setDBColumnName(metaColumn.getBindingDBColumnName() + "_begin");
                ctrlColumn.setPrecision(metaColumn.getPrecision());
                ctrlColumn.setScale(metaColumn.getScale());
                ctrlColumn.setLength(metaColumn.getLength());
                ctrlColumn.setAutoGen(true);
                ctrlColumn.setDataElementKey(metaColumn.getDataElementKey());
                ctrlColumn.setDataElement(metaColumn.getDataElement());
                ctrlColumn.setRefCol(metaColumn.getRefCol());
                autoGenColumnList.add(ctrlColumn);
                ctrlColumn = new MetaColumn();
                ctrlColumn.setKey(endColumn);
                ctrlColumn.setCaption(metaColumn.getCaption() + "_\u671f\u672b");
                ctrlColumn.setDataType(metaColumn.getDataType());
                ctrlColumn.setDBColumnName(metaColumn.getBindingDBColumnName() + "_end");
                ctrlColumn.setPrecision(metaColumn.getPrecision());
                ctrlColumn.setScale(metaColumn.getScale());
                ctrlColumn.setLength(metaColumn.getLength());
                ctrlColumn.setAutoGen(true);
                ctrlColumn.setDataElementKey(metaColumn.getDataElementKey());
                ctrlColumn.setDataElement(metaColumn.getDataElement());
                ctrlColumn.setRefCol(metaColumn.getRefCol());
                autoGenColumnList.add(ctrlColumn);
            }
            MetaColumn metaColumn2 = codeColumn = StringUtils.isBlank((CharSequence)(codeColumnKey = metaColumn.getCodeColumnKey())) ? null : (MetaColumn)this.get(codeColumnKey);
            if (codeColumn != null && StringUtils.isBlank((CharSequence)codeColumn.getDefaultValue())) {
                codeColumn.setDefaultValue("");
            }
        });
        Iterator itAutoGen = autoGenColumnList.iterator();
        MetaColumn ctrlColumn = null;
        while (itAutoGen.hasNext()) {
            ctrlColumn = (MetaColumn)itAutoGen.next();
            if (this.containsKey(ctrlColumn.getKey())) continue;
            this.add(ctrlColumn);
        }
        this.forEach(metaColumn -> metaColumn.doPostProcess(flag, callback));
        if (callback != null) {
            try {
                callback.call((Object)this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public AbstractMetaObject clone() {
        MetaTable newObject = (MetaTable)super.clone();
        newObject.setKey(this.key);
        newObject.setCaption(this.caption);
        newObject.setDBTableName(this.dbTableName);
        newObject.setTableMode(this.tableMode);
        newObject.setSourceType(this.sourceType);
        newObject.setPersist(this.persist);
        newObject.setStatement(this.statement);
        newObject.setFilter(this.filter != null ? (MetaTableFilter)this.filter.clone() : null);
        newObject.setStatement(this.statement == null ? null : (MetaStatement)this.statement.clone());
        newObject.setParentKey(this.parentKey);
        newObject.setHidden(this.hidden);
        newObject.setUniquePrimary(this.uniquePrimary);
        newObject.setRefreshFilter(this.refreshFilter);
        newObject.setHisTableName(this.hisTableName);
        newObject.setParameterCollection(this.parameterCollection == null ? null : (MetaParameterCollection)this.parameterCollection.clone());
        newObject.setSourceCollection(this.sourceCollection == null ? null : (MetaTableSourceCollection)this.sourceCollection.clone());
        newObject.setOrderBy(this.orderBy);
        newObject.setGroupBy(this.groupBy);
        newObject.setConvertor(this.convertor);
        newObject.setFormula(this.formula);
        newObject.setImpl(this.impl);
        newObject.setLoadInMidUse(this.loadInMidUse);
        newObject.setLazyLoad(this.lazyLoad);
        newObject.setIndexPrefix(this.indexPrefix);
        newObject.setPrimaryKey(this.primaryKey);
        newObject.setUseCursor(this.useCursor);
        newObject.setT(this.T);
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaTable();
    }

    public void setIndexPrefix(String indexPrefix) {
        this.indexPrefix = indexPrefix;
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    public String getIndexPrefix4Create() {
        if (this.indexPrefix == null || this.indexPrefix.isEmpty()) {
            if (this.tempIndexPrefix == null) {
                String tableKey = this.getBindingDBTableName();
                int length = tableKey.length();
                this.tempIndexPrefix = "I_" + (length > 15 ? tableKey.substring(length - 15) : tableKey);
            }
            return this.tempIndexPrefix;
        }
        return this.indexPrefix;
    }

    public String getIndexPrefix2() {
        if (this.indexPrefix == null || this.indexPrefix.isEmpty()) {
            if (this.tempIndexPrefix == null) {
                String tableKey = this.getBindingDBTableName();
                Double length = new Double(tableKey.length());
                if (length <= 17.0) {
                    this.tempIndexPrefix = "I_" + tableKey;
                } else {
                    StringBuffer sb = new StringBuffer("I_");
                    sb.append(tableKey.charAt(0));
                    sb.append(tableKey.charAt(tableKey.length() - 1));
                    for (int spiltCount = 2; spiltCount < 7; ++spiltCount) {
                        this.getSpiltInfo(tableKey, length, spiltCount, sb);
                        this.tempIndexPrefix = sb.toString();
                    }
                }
            }
            return this.tempIndexPrefix;
        }
        return this.indexPrefix;
    }

    private void getSpiltInfo(String s, Double length, int spiltCount, StringBuffer sb) {
        for (int i = 1; i < spiltCount; ++i) {
            Double index = length / (double)spiltCount * (double)i;
            sb.append(s.charAt(index.intValue()));
        }
    }

    public int getLevelID() {
        return this.levelID;
    }

    public void setLevelID(int levelID) {
        this.levelID = levelID;
    }

    public MetaParameterCollection getParameterCollection() {
        return this.parameterCollection;
    }

    public void setParameterCollection(MetaParameterCollection parameterCollection) {
        this.parameterCollection = parameterCollection;
    }

    public MetaColumn getMapCount() {
        return this.MapCount;
    }

    public void setMapCount(MetaColumn mapCount) {
        this.MapCount = mapCount;
    }

    public MetaColumn getSVERID() {
        return this.SVERID;
    }

    public void setSVERID(MetaColumn sVERID) {
        this.SVERID = sVERID;
    }

    public MetaColumn getSUBMITTER() {
        return this.SUBMITTER;
    }

    public void setSUBMITTER(MetaColumn sUBMITTER) {
        this.SUBMITTER = sUBMITTER;
    }

    public MetaColumn getCODE() {
        return this.CODE;
    }

    public void setCODE(MetaColumn CODE) {
        this.CODE = CODE;
    }

    public MetaColumn getSrcLangOID() {
        return this.SrcLangOID;
    }

    public void setSrcLangOID(MetaColumn SrcLangOID) {
        this.SrcLangOID = SrcLangOID;
    }

    public String getHisTableName() {
        return this.hisTableName;
    }

    public void setHisTableName(String hisTableName) {
        this.hisTableName = hisTableName;
    }

    public MetaColumn getLastModified() {
        return this.LastModified;
    }

    public void setLastModified(MetaColumn lastModified) {
        this.LastModified = lastModified;
    }

    public MetaColumn getCreateDate() {
        return this.CreateDate;
    }

    public void setCreateDate(MetaColumn createDate) {
        this.CreateDate = createDate;
    }

    public void initI18nColumn(IMetaFactory metaFactory) throws Throwable {
        if (!metaFactory.getSolution().isEnableMultiLang().booleanValue()) {
            return;
        }
        MetaLangConfig langConfig = metaFactory.getSolution().getLangConfig();
        LinkedList autoGenColumnList = new LinkedList();
        Iterator it = this.iterator();
        Object metaColumn = null;
        Iterator itAutoGen = autoGenColumnList.iterator();
        MetaColumn ctrlColumn = null;
        while (itAutoGen.hasNext()) {
            ctrlColumn = (MetaColumn)itAutoGen.next();
            this.add(ctrlColumn);
        }
    }

    @Override
    public void merge(MetaTable parentMetaTable) {
        Iterator metaColumns = parentMetaTable.iterator();
        if (parentMetaTable.statement != null) {
            if (this.statement != null) {
                parentMetaTable.statement.setType(this.statement.getType());
                parentMetaTable.statement.setDBType(this.statement.getDBType());
                parentMetaTable.statement.setDynamic(this.statement.isDynamic());
            }
            this.statement = parentMetaTable.statement;
        }
        if (parentMetaTable.orderBy != null) {
            this.orderBy = parentMetaTable.orderBy;
        }
        while (metaColumns.hasNext()) {
            MetaColumn metaColumn = (MetaColumn)metaColumns.next();
            if (this.containsKey(metaColumn.getKey())) continue;
            this.add((MetaColumn)metaColumn.clone());
        }
        if (parentMetaTable.indexCollection != null && !parentMetaTable.indexCollection.isEmpty()) {
            if (this.indexCollection == null || this.indexCollection.isEmpty()) {
                this.indexCollection = parentMetaTable.indexCollection;
            } else {
                for (MetaIndex metaIndex : parentMetaTable.indexCollection) {
                    if (this.indexCollection.containsKey(metaIndex.getKey())) {
                        ((MetaIndex)this.indexCollection.get(metaIndex.getKey())).merge(metaIndex);
                        continue;
                    }
                    this.indexCollection.add(metaIndex);
                }
            }
        }
    }
}

