/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.checker;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.checker.IMetaSolutionChecker;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class MetaDomainKeyChecker
implements IMetaSolutionChecker {
    @Override
    public void doCheck(IMetaFactory factory, String solutionKey) throws Throwable {
        if (solutionKey == null || solutionKey.isEmpty()) {
            return;
        }
        MetaDomainDef primaryDomainDef = factory.getDomainDef("");
        if (primaryDomainDef == null || primaryDomainDef.getDomainCollection() == null) {
            return;
        }
        MetaDomainDef domainDef = factory.getDomainDef(solutionKey);
        if (domainDef == null || domainDef.getDomainCollection() == null) {
            return;
        }
        Set<String> set1 = primaryDomainDef.getDomainCollection().keySet();
        Set<String> set2 = domainDef.getDomainCollection().keySet();
        HashSet<String> lowerCaseSet1 = new HashSet<String>();
        HashSet<String> lowerCaseSet2 = new HashSet<String>();
        for (String s : set1) {
            lowerCaseSet1.add(s.toLowerCase());
        }
        for (String s : set2) {
            lowerCaseSet2.add(s.toLowerCase());
        }
        TreeSet<String> intersection = new TreeSet<String>();
        intersection.addAll(lowerCaseSet1);
        intersection.retainAll(lowerCaseSet2);
        if (!intersection.isEmpty()) {
            String s;
            s = intersection.stream().collect(Collectors.joining(","));
            throw new MetaException(113, SimpleStringFormat.format((String)StringTable.getString(null, "", "RepeatKeyDefined"), (Object[])new Object[]{s}));
        }
    }
}

