/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.bpm.process;

import com.bokesoft.yes.meta.persist.dom.bpm.MetaBPMLoad;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionFolder;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.solution.MetaProject;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetaBPMReferenceScanLoad
extends BaseMetaScanLoad {
    private MetaBPM metaBPM;
    private ProcessDefinitionFolder root;
    private Map<String, ProcessDefinitionProfile> profileMap = new ConcurrentHashMap<String, ProcessDefinitionProfile>();
    private Map<String, ProcessDefinitionFolder> folderMap = new ConcurrentHashMap<String, ProcessDefinitionFolder>();
    private int runType = 1;

    public MetaBPMReferenceScanLoad(MetaBPM metaBPM, IMetaResolver resolver, MetaProject metaProject, Object context, int runType) throws Throwable {
        super(resolver, metaProject, metaProject.getKey() + File.separatorChar + "BPM", context);
        this.metaBPM = metaBPM;
        this.runType = runType;
        this.root = this.loadProcessFolder("", this.resourcePath);
    }

    @Override
    protected void loadImpl() throws Throwable {
        MetaBPMLoad BPMLoad = new MetaBPMLoad(this.runType);
        String resource = this.resourcePath + ".xml";
        BPMLoad.load(this.resolver, resource);
        MetaBPM mb = (MetaBPM)BPMLoad.getRootMetaObject();
        if (mb != null) {
            for (AbstractMetaObject info : mb.getMetaBPMDeployInfoCollection()) {
                this.metaBPM.getMetaBPMDeployInfoCollection().add(info);
            }
            for (AbstractMetaObject info : mb.getMetaProcessMapCollection()) {
                this.metaBPM.getMetaProcessMapCollection().add(info);
            }
        }
        this.scan(null, this.resourcePath);
    }

    @Override
    protected void postLoad() throws Throwable {
        super.postLoad();
        this.metaBPM.getProfileMap().putAll(this.getProfileMap());
    }

    @Override
    protected Object loadFolder(Object parent, String path, String filePath) throws Throwable {
        ProcessDefinitionFolder folder = new ProcessDefinitionFolder();
        folder.setPath(filePath);
        folder.setCaption(path);
        folder.setKey(path);
        this.folderMap.put(filePath, folder);
        return null;
    }

    private ProcessDefinitionFolder loadProcessFolder(String filePath, String fileName) throws Throwable {
        String resource = filePath + File.separatorChar + fileName;
        if (filePath.length() == 0) {
            resource = fileName;
        }
        ProcessDefinitionFolder folder = new ProcessDefinitionFolder();
        folder.setPath(resource);
        folder.setCaption(fileName);
        folder.setKey(fileName);
        this.folderMap.put(folder.getPath(), folder);
        if (filePath.length() == 0) {
            folder.setCaption("\u4e1a\u52a1\u6d41\u7a0b");
            return folder;
        }
        InputStream ins = this.resolver.read(resource + File.separatorChar + "folder-info", 0);
        if (ins != null) {
            Document document = DomHelper.createDocument((InputStream)ins);
            Element rootElement = document.getDocumentElement();
            String caption = DomHelper.readAttr((Element)rootElement, (String)"Caption", (String)"");
            folder.setCaption(caption);
            ins.close();
        }
        return folder;
    }

    @Override
    public ProcessDefinitionFolder getRoot() {
        return this.root;
    }

    public Map<String, ProcessDefinitionProfile> getProfileMap() {
        return this.profileMap;
    }

    @Override
    public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
        String tagName;
        JSONObject profileInfo = this.resolver.readProfile(filePath, 0);
        if (profileInfo != null && "Process".equals(tagName = profileInfo.optString("TagName"))) {
            ProcessDefinitionProfile processProfile = new ProcessDefinitionProfile();
            String key = profileInfo.optString("Key");
            String caption = profileInfo.optString("Caption");
            String versionStr = profileInfo.optString("Version");
            Integer version = versionStr == null || versionStr.length() == 0 ? 1 : Integer.parseInt(versionStr);
            processProfile.setKey(key);
            processProfile.setCaption(caption);
            processProfile.setVersion(version);
            processProfile.setResource(filePath);
            processProfile.setProject(this.metaProject);
            processProfile.setSourceType("Directory");
            this.profileMap.put(key + "_V" + version, processProfile);
            this.folderMap.get(parentPath).getProfileList().add(processProfile);
        }
    }
}

