/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.xml;

import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNode;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNodeDefine;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.LinkedData;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.CDataNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TextNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlCreator {
    private Document doc;
    private XmlTree orgTree;
    private LinkedHashMap<String, TagNode> mapNode = new LinkedHashMap();
    private DefaultNodeDefine defualtDefine = DefaultNodeDefine.getInstance();

    public XmlCreator(Document doc, XmlTree orgTree) {
        this.doc = doc;
        this.orgTree = orgTree;
    }

    public XmlTree createXmlTree() {
        this.mapNode.clear();
        XmlTree newTree = new XmlTree();
        Element elem = this.doc.getDocumentElement();
        String key = this.getKey(elem);
        TagNode node = this.orgTree == null ? null : this.orgTree.getTagNode(key);
        TagNode newRoot = this.createNewNodeByBaseNode(elem, node);
        this.createTagNode(elem, newRoot, true);
        if (this.orgTree != null) {
            newRoot.addPreComment(this.orgTree.getRoot().getPreComment());
            newRoot.addLastComment(this.orgTree.getRoot().getLastComment());
        }
        newTree.setRoot(newRoot);
        return newTree;
    }

    public String createXml() {
        XmlTree xmlTree = this.createXmlTree();
        this.createComments(xmlTree);
        return xmlTree.getRoot().toXml(0);
    }

    public HashMap<String, TagNode> getTagNodeMap() {
        return this.mapNode;
    }

    private void createComments(XmlTree xmlTree) {
        if (this.orgTree == null) {
            return;
        }
        TagNode root = xmlTree.getRoot();
        TagNode virtual = new TagNode();
        virtual.addNode(root);
        List<AbstractNode> listNode = this.orgTree.getNodesWithComment();
        for (AbstractNode nodeWithComment : listNode) {
            Stack<AbstractNode> stackPath = this.getCommentPath(nodeWithComment);
            TagNode levelNode = virtual;
            boolean bFind = false;
            AbstractNode pathNode = null;
            while (!stackPath.isEmpty() && levelNode != null) {
                pathNode = stackPath.pop();
                if (pathNode instanceof TagNode) {
                    TagNode tagNode = (TagNode)pathNode;
                    bFind = (levelNode = levelNode.findChildByTagNode(tagNode)) != null;
                    continue;
                }
                bFind = false;
                break;
            }
            if (!bFind) continue;
            levelNode.addPreComment(pathNode.getPreComment());
            levelNode.addLastComment(pathNode.getLastComment());
        }
    }

    private Stack<AbstractNode> getCommentPath(AbstractNode nodeWithComment) {
        Stack<AbstractNode> stack = new Stack<AbstractNode>();
        for (AbstractNode parent = nodeWithComment; parent != null; parent = parent.getParent()) {
            stack.push(parent);
        }
        return stack;
    }

    private void createTagNode(Element elem, TagNode parentTagNode, boolean isRoot) {
        String key = this.getKey(elem);
        TagNode node = this.orgTree == null ? null : this.orgTree.getTagNode(key);
        TagNode newTagNode = null;
        if (!isRoot) {
            newTagNode = this.createNewNodeByBaseNode(elem, node);
            parentTagNode.addNode(newTagNode);
            String par = "";
            if (newTagNode.getParent() != null) {
                par = newTagNode.getParent().getPrimaryKey();
                if (newTagNode.getParent().getParent() != null) {
                    par = newTagNode.getParent().getParent().getPrimaryKey() + "->" + par;
                }
            }
            this.mapNode.put(par + "->" + newTagNode.getPrimaryKey(), newTagNode);
        } else {
            newTagNode = parentTagNode;
        }
        Node child = null;
        String sContent = null;
        NodeList nodeList = elem.getChildNodes();
        for (int n = 0; n < nodeList.getLength(); ++n) {
            child = nodeList.item(n);
            if (1 == child.getNodeType()) {
                this.createTagNode((Element)child, newTagNode, false);
                continue;
            }
            if (4 == child.getNodeType()) {
                newTagNode.addNode(new CDataNode(child.getNodeValue()));
                continue;
            }
            if (3 != child.getNodeType() || (sContent = child.getTextContent()) == null || sContent.trim().length() <= 0) continue;
            newTagNode.addNode(new TextNode(sContent));
        }
    }

    private TagNode createNewNodeByBaseNode(Element curElem, TagNode baseTagNode) {
        LinkedData firstAttr;
        if (baseTagNode == null) {
            return this.createNewNodeByDefault(curElem);
        }
        String curNodeName = curElem.getNodeName();
        DefaultNode newElementAttrs = new DefaultNode(curNodeName);
        Set<String> keySet = baseTagNode.getAttributes().keySet();
        for (String attrName : keySet) {
            if (!curElem.hasAttribute(attrName)) continue;
            newElementAttrs.addNode(new LinkedData(attrName));
        }
        DefaultNode defaultNode = this.defualtDefine.getDefaultNode(curNodeName);
        NamedNodeMap curAttrs = curElem.getAttributes();
        for (int i = 0; i < curAttrs.getLength(); ++i) {
            String attrName = curAttrs.item(i).getNodeName();
            if (newElementAttrs.hasAttribute(attrName)) continue;
            if (defaultNode != null && defaultNode.hasAttribute(attrName)) {
                LinkedData lastDefinedAttr = this.findLastDefinedAttr(newElementAttrs, defaultNode);
                newElementAttrs.addNode(new LinkedData(attrName), lastDefinedAttr);
                continue;
            }
            newElementAttrs.addNode(new LinkedData(attrName));
        }
        LinkedData tmp = firstAttr = newElementAttrs.first();
        TagNode newTagNode = new TagNode(curNodeName);
        while (tmp != null) {
            String attrName = tmp.getValue();
            newTagNode.setAttribute(attrName, curElem.getAttribute(attrName));
            tmp = tmp.next;
        }
        return newTagNode;
    }

    public TagNode createNewNodeByBaseNode(TagNode curElem, TagNode baseTagNode) {
        LinkedData firstAttr;
        if (baseTagNode == null) {
            return this.createNewNodeByDefault(curElem);
        }
        String curNodeName = curElem.getTagName();
        DefaultNode newElementAttrs = new DefaultNode(curNodeName);
        Set<String> keySet = baseTagNode.getAttributes().keySet();
        for (String attrName : keySet) {
            if (!curElem.hasAttribute(attrName)) continue;
            newElementAttrs.addNode(new LinkedData(attrName));
        }
        DefaultNode defaultNode = this.defualtDefine.getDefaultNode(curNodeName);
        Map<String, String> attributes = curElem.getAttributes();
        attributes.forEach((key, abs) -> {
            if (!newElementAttrs.hasAttribute((String)key)) {
                if (defaultNode != null && defaultNode.hasAttribute((String)key)) {
                    LinkedData lastDefinedAttr = this.findLastDefinedAttr(newElementAttrs, defaultNode);
                    newElementAttrs.addNode(new LinkedData((String)key), lastDefinedAttr);
                } else {
                    newElementAttrs.addNode(new LinkedData((String)key));
                }
            }
        });
        LinkedData tmp = firstAttr = newElementAttrs.first();
        TagNode newTagNode = new TagNode(curNodeName);
        while (tmp != null) {
            String attrName = tmp.getValue();
            newTagNode.setAttribute(attrName, curElem.getAttributes().get(attrName));
            tmp = tmp.next;
        }
        return newTagNode;
    }

    private TagNode createNewNodeByDefault(Element curElem) {
        String attrName;
        String nodeName = curElem.getNodeName();
        TagNode newTagNode = new TagNode(nodeName);
        DefaultNode defaultNode = this.defualtDefine.getDefaultNode(nodeName);
        if (defaultNode != null) {
            for (LinkedData attrData : defaultNode.values()) {
                attrName = attrData.getValue();
                if (!curElem.hasAttribute(attrName)) continue;
                newTagNode.setAttribute(attrName, curElem.getAttribute(attrName));
            }
        }
        NamedNodeMap curAttrs = curElem.getAttributes();
        for (int i = 0; i < curAttrs.getLength(); ++i) {
            attrName = curAttrs.item(i).getNodeName();
            if (newTagNode.hasAttribute(attrName)) continue;
            newTagNode.setAttribute(attrName, curElem.getAttribute(attrName));
        }
        return newTagNode;
    }

    private TagNode createNewNodeByDefault(TagNode curElem) {
        String nodeName = curElem.getTagName();
        TagNode newTagNode = new TagNode(nodeName);
        DefaultNode defaultNode = this.defualtDefine.getDefaultNode(nodeName);
        if (defaultNode != null) {
            for (LinkedData attrData : defaultNode.values()) {
                String attrName = attrData.getValue();
                if (!curElem.hasAttribute(attrName)) continue;
                newTagNode.setAttribute(attrName, curElem.getAttributes().get(attrName));
            }
        }
        Map<String, String> attributes = curElem.getAttributes();
        attributes.forEach((key, abs) -> {
            if (!newTagNode.hasAttribute((String)key)) {
                newTagNode.setAttribute((String)key, (String)abs);
            }
        });
        return newTagNode;
    }

    private LinkedData findLastDefinedAttr(DefaultNode linkAttrs, DefaultNode defaultAttrs) {
        LinkedData tmpData = linkAttrs.last();
        while (tmpData != null) {
            if (defaultAttrs.hasAttribute(tmpData.getValue())) {
                return tmpData;
            }
            tmpData = tmpData.previous;
        }
        return null;
    }

    private Node getCDataNode(Element elem) {
        Node node = null;
        NodeList nodeList = elem.getChildNodes();
        for (int n = 0; n < nodeList.getLength(); ++n) {
            node = nodeList.item(n);
            if (4 == node.getNodeType()) {
                return node;
            }
            if (1 != node.getNodeType()) continue;
            return null;
        }
        return null;
    }

    private String getKey(Element elem) {
        String tagName = elem.getTagName();
        String primaryKey = this.defualtDefine.getPrimaryKey(tagName);
        String attrKey = elem.getAttribute(primaryKey);
        Node parentNode = elem.getParentNode();
        String parentPrimaryKey = "";
        parentPrimaryKey = this.getParentPrimaryKey(parentNode, parentPrimaryKey);
        return parentPrimaryKey.concat("->").concat(tagName).concat("@").concat(attrKey);
    }

    private String getParentPrimaryKey(Node parentNode, String parentPrimaryKey) {
        if (parentNode != null && parentNode instanceof Element) {
            Element parentNode1 = (Element)parentNode;
            String tagName1 = parentNode1.getTagName();
            String key = parentNode1.getAttribute("Key");
            parentPrimaryKey = StringUtils.isEmpty((CharSequence)key) ? parentPrimaryKey.concat(this.getParentPrimaryKey(parentNode1.getParentNode(), parentPrimaryKey)) : tagName1.concat("@").concat(key);
        }
        return parentPrimaryKey;
    }
}

