/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.flatcanvas.MetaFlatCanvasList;
import com.bokesoft.yigo.meta.flatcanvas.MetaFlatCanvasProfile;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class MetaFlatCanvasScanLoad
extends BaseMetaScanLoad {
    private int runType = 1;
    private MetaFlatCanvasList flatCanvasList = null;
    private Map<String, MetaFlatCanvasProfile> map = null;

    public MetaFlatCanvasScanLoad(MetaFlatCanvasList flatCanvasList, IMetaResolver resolver, MetaProject metaProject, Object context, int runType) {
        super(resolver, metaProject, "FlatCanvas", context);
        this.flatCanvasList = flatCanvasList;
        this.runType = runType;
        this.map = new ConcurrentHashMap<String, MetaFlatCanvasProfile>();
    }

    protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaFlatCanvasProfile profile) {
    }

    @Override
    protected void postLoad() throws Throwable {
        super.postLoad();
        this.merge();
    }

    @Override
    public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
        String tagName;
        JSONObject profileInfo = this.resolver.readProfile(filePath, 0);
        if (profileInfo != null && "Paper".equals(tagName = profileInfo.optString("TagName"))) {
            MetaFlatCanvasProfile profile = new MetaFlatCanvasProfile();
            profile.setKey(profileInfo.optString("key"));
            profile.setCaption(profileInfo.optString("caption"));
            profile.setProject(this.metaProject);
            profile.setResource(filePath);
            if (this.map.containsKey(profile.getKey())) {
                MetaFlatCanvasProfile tmpFlatCanvasProfile = (MetaFlatCanvasProfile)this.flatCanvasList.get(profile.getKey());
                IMetaProject tmpProject = tmpFlatCanvasProfile.getProject();
                throw new MetaException(70, SimpleStringFormat.format((String)StringTable.getString(null, "", "RepeatFlatCanvasDefined"), (Object[])new Object[]{this.metaProject.getKey(), profile.getKey(), tmpProject.getKey()}));
            }
            this.doFind(parent, parentPath, filePath, fileName, profile);
            this.map.put(profile.getKey(), profile);
        }
    }

    public int getRunType() {
        return this.runType;
    }

    private void merge() {
        if (this.map.isEmpty()) {
            return;
        }
        try {
            this.flatCanvasList.putAll(this.map);
        }
        finally {
            this.map.clear();
        }
    }

    public MetaFlatCanvasList getMetaFlatCanvasList() {
        this.merge();
        return this.flatCanvasList;
    }
}

