package com.bokesoft.yigo.meta.util.compext;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;

import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaCustom;
import com.bokesoft.yigo.meta.form.component.control.MetaAttachment;
import com.bokesoft.yigo.meta.form.component.control.MetaBPMGraph;
import com.bokesoft.yigo.meta.form.component.control.MetaBarCoder;
import com.bokesoft.yigo.meta.form.component.control.MetaButton;
import com.bokesoft.yigo.meta.form.component.control.MetaCheckBox;
import com.bokesoft.yigo.meta.form.component.control.MetaCheckListBox;
import com.bokesoft.yigo.meta.form.component.control.MetaComboBox;
import com.bokesoft.yigo.meta.form.component.control.MetaComboView;
import com.bokesoft.yigo.meta.form.component.control.MetaCountDownView;
import com.bokesoft.yigo.meta.form.component.control.MetaCountUp;
import com.bokesoft.yigo.meta.form.component.control.MetaDatePicker;
import com.bokesoft.yigo.meta.form.component.control.MetaDateRangePicker;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.MetaDictPane;
import com.bokesoft.yigo.meta.form.component.control.MetaDictSearchBox;
import com.bokesoft.yigo.meta.form.component.control.MetaDropdownButton;
import com.bokesoft.yigo.meta.form.component.control.MetaDynamicDict;
import com.bokesoft.yigo.meta.form.component.control.MetaEmpty;
import com.bokesoft.yigo.meta.form.component.control.MetaFileChooser;
import com.bokesoft.yigo.meta.form.component.control.MetaFlatCanvas;
import com.bokesoft.yigo.meta.form.component.control.MetaGIFImage;
import com.bokesoft.yigo.meta.form.component.control.MetaGridDesigner;
import com.bokesoft.yigo.meta.form.component.control.MetaHoverButton;
import com.bokesoft.yigo.meta.form.component.control.MetaHyperLink;
import com.bokesoft.yigo.meta.form.component.control.MetaIcon;
import com.bokesoft.yigo.meta.form.component.control.MetaImage;
import com.bokesoft.yigo.meta.form.component.control.MetaImageList;
import com.bokesoft.yigo.meta.form.component.control.MetaLabel;
import com.bokesoft.yigo.meta.form.component.control.MetaMonthPicker;
import com.bokesoft.yigo.meta.form.component.control.MetaMultiStateButton;
import com.bokesoft.yigo.meta.form.component.control.MetaNoticeBar;
import com.bokesoft.yigo.meta.form.component.control.MetaNumberEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaNumberInfoEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaPasswordEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaPopButton;
import com.bokesoft.yigo.meta.form.component.control.MetaPriceLabel;
import com.bokesoft.yigo.meta.form.component.control.MetaProgressBar;
import com.bokesoft.yigo.meta.form.component.control.MetaRelativeTime;
import com.bokesoft.yigo.meta.form.component.control.MetaScoreBar;
import com.bokesoft.yigo.meta.form.component.control.MetaSearchBox;
import com.bokesoft.yigo.meta.form.component.control.MetaSegmentedControl;
import com.bokesoft.yigo.meta.form.component.control.MetaSeparator;
import com.bokesoft.yigo.meta.form.component.control.MetaSlider;
import com.bokesoft.yigo.meta.form.component.control.MetaSplitButton;
import com.bokesoft.yigo.meta.form.component.control.MetaStepEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaSubForm;
import com.bokesoft.yigo.meta.form.component.control.MetaSwitch;
import com.bokesoft.yigo.meta.form.component.control.MetaTextArea;
import com.bokesoft.yigo.meta.form.component.control.MetaTextButton;
import com.bokesoft.yigo.meta.form.component.control.MetaTextEditor;
import com.bokesoft.yigo.meta.form.component.control.MetaTimeCountDown;
import com.bokesoft.yigo.meta.form.component.control.MetaTimePicker;
import com.bokesoft.yigo.meta.form.component.control.MetaToggleButton;
import com.bokesoft.yigo.meta.form.component.control.MetaUTCDatePicker;
import com.bokesoft.yigo.meta.form.component.control.MetaUploadButton;
import com.bokesoft.yigo.meta.form.component.control.MetaVideoPlayer;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.progressindicator.MetaProgressIndicator;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaAttachmentProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaBPMGraphProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaBarCoderProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckListBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboViewProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCountDownViewProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCountUpProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCustomProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDatePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDateRangePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictPaneProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictSearchBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaEmptyProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFileChooserProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFlatCanvasProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaGIFImageProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaGridDesignerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHoverButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHyperLinkProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaIconProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageListProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaLabelProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaMonthPickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaMultiStateButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNoticeBarProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberInfoEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPasswordEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPopButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPriceLabelProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressBarProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressIndicatorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaRelativeTimeProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaScoreBarProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSearchBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSegmentedControlProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSeparatorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSliderProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSplitButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStepEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSubFormProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSwitchProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextAreaProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTimeCountDownProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTimePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaToggleButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaUTCDatePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaUploadButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaVideoPlayerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaWizardListProperties;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardList;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.panel.MetaBorderLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaColumnLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaFlexFlowLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaFlowLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaGeneralPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaHtmlPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaLinearLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaPagePanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaSlidingLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaTabPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaWizardPanel;
import com.bokesoft.yigo.meta.form.component.panel.FlexBoxPanel.MetaFlexBoxPanel;
import com.bokesoft.yigo.meta.form.component.panel.collapsepanel.MetaCollapsePanel;
import com.bokesoft.yigo.meta.form.component.panel.customlayoutpanel.MetaCustomLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.flexgridpanel.MetaFlexGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.tablepanel.MetaFluidTableLayoutPanel;

/**
 * 属性与方法的集合（类型未整合到一起）
 *
 */
public class FieldAndMethodMap {

	private static FieldAndMethodMap instance = null;
	
	/** 控件（和properties）中的setXXX方法集合*/
	private HashMap<String, HashMap<String, Method>> setMethodMap = null;
	
	private HashMap<String, HashMap<String, Method>> getMethodMap = null;
	
	/** 控件（和properties）中的ClassRef集合，包括metaComponent中那部分*/
	private HashMap<String, HashMap<String, Class<?>>> fieldClassRefMap = null;

	/** MetaComponent 中保存的classRef，处理时合并到每个控件中 */
	private HashMap<String, Class<?>> metaComponetFieldClassRefMap = null;
	private HashMap<String, Class<?>> metaPanelFieldClassRefMap = null;
	
	/** 字段与标签属性名的映射 （解决字段与xml标签中属性名不统一） */
	private HashMap<String, HashMap<String, String>> fieldAttrRefMap = null;
	
	public FieldAndMethodMap() {
		this.setMethodMap = new HashMap<String, HashMap<String, Method>>();
		this.getMethodMap = new HashMap<String, HashMap<String, Method>>();
		
		this.metaComponetFieldClassRefMap = new HashMap<String, Class<?>>();
		this.metaPanelFieldClassRefMap = new HashMap<String, Class<?>>();
		
		this.fieldClassRefMap = new HashMap<String, HashMap<String, Class<?>>>();
		
		this.fieldAttrRefMap = new HashMap<String, HashMap<String, String>>();
		
		this.init();
	}
	
	public static FieldAndMethodMap getInstance() {
		if (instance == null) {
			instance = new FieldAndMethodMap();
		}
		return instance;
	}
	
	/**
	 * 后面改成扫包形式
	 * @return
	 */
	private Class<?>[] getClazzArray() {
		return new Class[] {
				// 控件
				MetaLabel.class,
				MetaPriceLabel.class,
				MetaRelativeTime.class,
				MetaButton.class,
				MetaNoticeBar.class,
				MetaBarCoder.class,
				MetaToggleButton.class,
				MetaMultiStateButton.class,
				MetaTextEditor.class,
				MetaTextButton.class,
				MetaNumberEditor.class,
				MetaCheckBox.class,
				MetaDict.class,
				MetaDatePicker.class,
				MetaUTCDatePicker.class,
				MetaComboBox.class,
				MetaCheckListBox.class,
				MetaImage.class,
				MetaVideoPlayer.class,
				MetaHyperLink.class,
				MetaDynamicDict.class,
				MetaCustom.class,
				MetaTextArea.class,
				MetaMonthPicker.class,
				MetaTimePicker.class,
				MetaIcon.class,
				MetaImageList.class,
				MetaStepEditor.class,
				MetaUploadButton.class,
				MetaWizardList.class,
				MetaAttachment.class,
				MetaBPMGraph.class,
				MetaComboView.class,
				MetaCountDownView.class,
				MetaCountUp.class,
				MetaDateRangePicker.class,
				MetaDictPane.class,
				MetaDictSearchBox.class,
				MetaDropdownButton.class,
				MetaDropdownItem.class,
				MetaEmpty.class,
				MetaFileChooser.class,
				MetaFlatCanvas.class,
				MetaGIFImage.class,
				MetaGridDesigner.class,
				MetaHoverButton.class,
				MetaNumberInfoEditor.class,
				MetaPasswordEditor.class,
				MetaPopButton.class,
				MetaProgressBar.class,
				MetaProgressIndicator.class,
				MetaScoreBar.class,
				MetaSearchBox.class,
				MetaSegmentedControl.class,
				MetaSeparator.class,
				MetaSlider.class,
				MetaSplitButton.class,
				MetaSubForm.class,
				MetaSwitch.class,
				MetaTimeCountDown.class,
				// 控件属性
				MetaLabelProperties.class,
				MetaPriceLabelProperties.class,
				MetaRelativeTimeProperties.class,
				MetaButtonProperties.class,
				MetaNoticeBarProperties.class,
				MetaBarCoderProperties.class,
				MetaToggleButtonProperties.class,
				MetaMultiStateButtonProperties.class,
				MetaTextEditorProperties.class,
				MetaTextButtonProperties.class,
				MetaNumberEditorProperties.class,
				MetaCheckBoxProperties.class,
				MetaDictProperties.class,
				MetaDatePickerProperties.class,
				MetaUTCDatePickerProperties.class,
				MetaComboBoxProperties.class,
				MetaCheckListBoxProperties.class,
				MetaImageProperties.class,
				MetaVideoPlayerProperties.class,
				MetaHyperLinkProperties.class,
				MetaCustomProperties.class,
				// MetaDynamicProperties.class,
				MetaTextAreaProperties.class,
				MetaMonthPickerProperties.class,
				MetaTimePickerProperties.class,
				MetaIconProperties.class,
				MetaImageListProperties.class,
				MetaStepEditorProperties.class,
				MetaUploadButtonProperties.class,
				MetaWizardListProperties.class,
				MetaAttachmentProperties.class,
				MetaBPMGraphProperties.class,
				MetaComboViewProperties.class,
				MetaCountDownViewProperties.class,
				MetaCountUpProperties.class,
				MetaDateRangePickerProperties.class,
				MetaDictPaneProperties.class,
				MetaDictSearchBoxProperties.class,
				MetaDropdownButtonProperties.class,
				MetaEmptyProperties.class,
				MetaFileChooserProperties.class,
				MetaFlatCanvasProperties.class,
				MetaGIFImageProperties.class,
				MetaGridDesignerProperties.class,
				MetaHoverButtonProperties.class,
				MetaNumberInfoEditorProperties.class,
				MetaPasswordEditorProperties.class,
				MetaPopButtonProperties.class,
				MetaProgressBarProperties.class,
				MetaProgressIndicatorProperties.class,
				MetaScoreBarProperties.class,
				MetaSearchBoxProperties.class,
				MetaSegmentedControlProperties.class,
				MetaSeparatorProperties.class,
				MetaSliderProperties.class,
				MetaSplitButtonProperties.class,
				MetaSubFormProperties.class,
				MetaSwitchProperties.class,
				MetaTimeCountDownProperties.class,
				// 表格
				MetaGrid.class,
				MetaGridCell.class,
				MetaGridRow.class,
				// 列表
				MetaListView.class,
				MetaListViewColumn.class,
				// 面板
				MetaColumnLayoutPanel.class,
				MetaTabPanel.class,
				MetaPagePanel.class,
				MetaLinearLayoutPanel.class,
				MetaSplitPanel.class,
				MetaHtmlPanel.class,
				MetaCollapsePanel.class,
				MetaWizardPanel.class,
				MetaSlidingLayoutPanel.class,
				MetaGridLayoutPanel.class,
				MetaFlowLayoutPanel.class,
				MetaBorderLayoutPanel.class,
				MetaFlexFlowLayoutPanel.class,
				MetaGeneralPanel.class,
				MetaFluidTableLayoutPanel.class,
				MetaCustomLayoutPanel.class,
				MetaFlexBoxPanel.class,
				MetaFlexGridLayoutPanel.class
		};
	}
	
	/**
	 * 获取字段对应的get方法
	 * 
	 * @return
	 */
	public Method getGetMethod(String clazzName, String fieldName) {
		Method md = null;
		
		fieldName = getAttrFieldName(clazzName, fieldName);
	
		HashMap<String, Method> mapMethod = getMethodMap.get(clazzName);
		if (mapMethod != null) {
			md = mapMethod.get(fieldName);
		}
		
		return md;
	}
	
	/**
	 * 获取字段对应的set方法
	 * 
	 * @param clazzName 类名
	 * @param fieldName xml中属性名
	 * @return
	 */
	public Method getSetMethod(String clazzName, String fieldName) {
		Method md = null;
		
		fieldName = getAttrFieldName(clazzName, fieldName);
		
		HashMap<String, Method> mapMethod = setMethodMap.get(clazzName);
		if (mapMethod != null) {
			md = mapMethod.get(fieldName);
		}
		
		return md;
	}
	
	private String getAttrFieldName(String clazzName, String attrName) {
		HashMap<String, String> fieldAttr = this.fieldAttrRefMap.get(clazzName);
		
		if (fieldAttr != null) {
			String fieldName = fieldAttr.get(attrName);
			if (fieldName != null) {
				return fieldName;
			}
		}
		
		return attrName;
	}
	
	public Class<?> getParseClass(String clazzName, String fieldName) {
		Class<?> clazz = null;	
		
		fieldName = getAttrFieldName(clazzName, fieldName);
		HashMap<String, Class<?>> mapClassRef = fieldClassRefMap.get(clazzName);
		if (mapClassRef != null) {
			clazz = mapClassRef.get(fieldName);
		}
	
		return clazz;
	}
	
	private void init() {
		// 初始化 metaComponet, metaPanel 中的ClassRef集合
		Field[] fields = MetaComponent.class.getDeclaredFields();
		int length = fields.length;
		
		Field field = null;
		ClassRef annotation = null;
		
		for (int i = 0; i < length; ++ i) {
			field = fields[i];
			annotation = field.getAnnotation(ClassRef.class);
			
			if (annotation != null) {
				this.metaComponetFieldClassRefMap.put(field.getName().toLowerCase(), annotation.value());
			}
		}
		
		fields = MetaPanel.class.getDeclaredFields();
		length = fields.length;
		for (int i = 0; i < length; ++ i) {
			field = fields[i];
			annotation = field.getAnnotation(ClassRef.class);
			
			if (annotation != null) {
				this.metaPanelFieldClassRefMap.put(field.getName().toLowerCase(), annotation.value());
			}
		}
		
		Class<?>[] cls = this.getClazzArray();
		for (int i = 0; i < cls.length; i ++) {
			this.createSetMethodAndFiledMap(cls[i]);		
		}		
	}
	
	private void createSetMethodAndFiledMap(Class<?> clazz) {
		Method[] methods = clazz.getMethods();
		Field[] fields = clazz.getDeclaredFields();
		
		HashMap<String, Method> setMapMethod = new HashMap<String, Method>();
		HashMap<String, Method> getMapMethod = new HashMap<String, Method>();
		
		int length = methods.length;
		Method method = null;
		String methodName = null;
		String propName = null;
		
		for (int i = 0; i < length; ++ i) {
			method = methods[i];
			methodName = method.getName();
			if (methodName.length() > 3
					&& methodName.substring(0, 3).equals("set")) {
				propName = methodName.substring(3);
				setMapMethod.put(propName.toLowerCase(), method);
			}
			
			if (methodName.length() > 3
					&& methodName.substring(0, 3).equals("get")) {
				propName = methodName.substring(3);
				getMapMethod.put(propName.toLowerCase(), method);
			}
			
			if (methodName.length() > 2
					&& methodName.substring(0, 2).equals("is")) {
				propName = methodName.substring(2);
				getMapMethod.put(propName.toLowerCase(), method);
			}
		}
		
		this.setMethodMap.put(clazz.getName(), setMapMethod);
		this.getMethodMap.put(clazz.getName(), getMapMethod);
		
		length = fields.length;
		Field field = null;
		HashMap<String, Class<?>> mapClassRef = new HashMap<String, Class<?>>();
		HashMap<String, String> mapAttrRef = new HashMap<String, String>();
		for (int i = 0; i < length; ++ i) {
			field = fields[i];
			ClassRef annotation = field.getAnnotation(ClassRef.class);
			AttributeRef attrAnnotation = field.getAnnotation(AttributeRef.class);
			if (annotation != null) {
				mapClassRef.put(field.getName().toLowerCase(), annotation.value());
			}
			
			if (attrAnnotation != null) {
				mapAttrRef.put(attrAnnotation.value().toLowerCase(), field.getName().toLowerCase());
			}
		}

		if (MetaComponent.class.isAssignableFrom(clazz)) {
			mapClassRef.putAll(this.metaComponetFieldClassRefMap);
		}
		
		if (MetaPanel.class.isAssignableFrom(clazz)) {
			mapClassRef.putAll(this.metaPanelFieldClassRefMap);
		}

		this.fieldClassRefMap.put(clazz.getName(), mapClassRef);
		this.fieldAttrRefMap.put(clazz.getName(), mapAttrRef);
	}
	

}
