package com.bokesoft.yigo.meta.setting;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaCluster定义数据的逻辑划分的设置
 * 
 * @author 王元和
 *
 */
public class MetaCluster extends AbstractMetaObject {

	public static final String TAG_NAME = "Cluster";

	/** 逻辑划分类型 */
	private Integer type = -1;
	/** 逻辑划分依据的字典标识 */
	private String refItemKey = "";
	/** 自定义实现类的路径 */
	private String impl = "";
	/** 内置管理员可操作的字典标识*/
	private String adminItemKey = "";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 设置逻辑划分的类型
	 * 
	 * @param type
	 *            类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}

	/**
	 * 取得逻辑划分的类型
	 * 
	 * @return 类型
	 */
	public Integer getType() {
		return this.type;
	}

	/**
	 * 设置依据的字典标识
	 * 
	 * @param refItemKey
	 *            字典标识
	 */
	public void setRefItemKey(String refItemKey) {
		this.refItemKey = refItemKey;
	}

	/**
	 * 取得依据的字典标识
	 * 
	 * @return 字典标识
	 */
	public String getRefItemKey() {
		return this.refItemKey;
	}

	public String getImpl() {
		return impl;
	}

	public void setImpl(String impl) {
		this.impl = impl;
	}
	
	public void setAdminItemKey(String adminItemKey){
		this.adminItemKey = adminItemKey;
	}
	
	public String getAdminItemKey(){
		return adminItemKey;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCluster newObject = new MetaCluster();
		newObject.setType(type);
		newObject.setRefItemKey(refItemKey);
		newObject.setAdminItemKey(adminItemKey);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCluster();
	}

}
