package com.bokesoft.yigo.meta.setting;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;

/**
 * 流程迁移设置
 * 
 * @author 刘翔翔
 *
 */
public class MetaBPMMTable extends GenericKeyCollection<MetaBPMMColumn> {

	/** 列的标签名 */
	public static final String TAG_NAME = "Table";

	/** 激活流程迁移 */
	private Boolean activateMigration = true;

	// 并非文件属性
	/** 运行时是否完成初始化 */
	private boolean inited = false;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public void init(IMetaFactory metaFactory) throws Throwable {
		if (!inited) {
			synchronized (this) {
				if (!inited) {
					MetaDataObject dataObject = metaFactory.getDataObject(MetaBPM.DATA_MIGRATION_KEY);
					if (dataObject != null)
						join(dataObject);
					inited = true;
				}
			}

		}
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	public Boolean isActivateMigration() {
		return activateMigration;
	}

	public void setActivateMigration(Boolean activateMigration) {
		this.activateMigration = activateMigration;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaBPMMColumn.TAG_NAME.equals(tagName)) {
			resultMetaObject = new MetaBPMMColumn();
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
			add((MetaBPMMColumn) resultMetaObject);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBPMMTable();
	}

	public void join(MetaDataObject dataObject) {
		MetaTable ttable = dataObject.getTable(dataObject.getMainTableKey());
		if (ttable != null) {
			for (MetaColumn column : ttable) {
				if (containsKey(column.getKey()))
					continue;
				if (SystemField.isSystemField(column.getKey()))
					continue;
				MetaBPMMColumn c = new MetaBPMMColumn();
				c.setCaption(column.getCaption());
				c.setKey(column.getKey());
				c.setDataType(column.getDataType());
				c.setDBColumnName(column.getDBColumnName());
				c.setDefaultValue(column.getDefaultValue());
				c.setLength(column.getLength());
				c.setPrecision(column.getPrecision());
				c.setScale(column.getScale());
				add(c);
			}
		}
	}

	public boolean isInited() {
		return inited;
	}

	public void setInited(boolean inited) {
		this.inited = inited;
	}

}
