package com.bokesoft.yigo.meta.schema;

import java.util.HashSet;
import java.util.Set;

/**
 * 用于需要创建的数据库表的表结构的对象。
 */
public class MetaSchemaTable {
	/** 表的标识 */
	private String key = "";
	/** 表的名称 */
	private String caption = "";
	/** 表的描述 */
	private String description = "";
	/** 表的列 */
	private MetaSchemaColumnCollection columnCollection = null;
	/** 表的索引 */
	private MetaIndexCollection indexCollection = null;
	/** 主键字段标志 */
	private String primaryKey = null;

	/** 系统自动生成标识 */
	private boolean autoGen = false;

	private String partitionMethod;

	private Set<String> partitionColumnSet;

	/** 是否迁移表 (如果true，则在MySqlCluster环境下，不能把Soid变成唯一索引和分组字段) */
	private boolean migration;

	public MetaSchemaTable() {
		columnCollection = new MetaSchemaColumnCollection();
		indexCollection = new MetaIndexCollection();
		partitionMethod = "";
		partitionColumnSet = new HashSet<>();
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public MetaSchemaColumnCollection getColumnCollection() {
		return columnCollection;
	}

	public void setColumnCollection(MetaSchemaColumnCollection columnCollection) {
		this.columnCollection = columnCollection;
	}

	public MetaIndexCollection getIndexCollection() {
		return indexCollection;
	}

	public void setIndexCollection(MetaIndexCollection indexCollection) {
		this.indexCollection = indexCollection;
	}

	public void setPrimaryKey(String primaryKey) {
		this.primaryKey = primaryKey;
	}

	public String getPrimaryKey() {
		if (primaryKey != null && !primaryKey.isEmpty()) {
			return primaryKey;
		}
		return key;
	}

	public boolean isAutoGen() {
		return autoGen;
	}

	public void setAutoGen(boolean autoGen) {
		this.autoGen = autoGen;
	}

	public boolean addPartitionColumn(MetaSchemaColumn e) {
		return partitionColumnSet.add(e.getKey());
	}

	public String getPartitionMethod() {
		return partitionMethod;
	}

	public void setPartitionMethod(String partitionMethod) {
		this.partitionMethod = partitionMethod;
	}

	public Set<String> getPartitionColumnSet() {
		return partitionColumnSet;
	}

	public boolean isMigration() {
		return migration;
	}

	public void setMigration(boolean migration) {
		this.migration = migration;
	}

	/**
	 * 检查热更新前后表的结构是否发生变化
	 * @param oldTable 更新前的表
	 * @return 发生变化返回true；否则返回false
	 */
	public boolean compare(MetaSchemaTable oldTable) {
		if (oldTable == null) {
			return true;
		}
		if (this.getKey().equals(oldTable.getKey())) {
			//检查列是否发生变化
			MetaSchemaColumnCollection oldColumns = oldTable.getColumnCollection();
			MetaSchemaColumnCollection newColumns = this.getColumnCollection();
			for (MetaSchemaColumn newColumn : newColumns) {
				if (!oldColumns.containsKey(newColumn.getKey())) {
					return true;
				}
			}
			//检查索引是否发生变化
			MetaIndexCollection oldIndexs = oldTable.getIndexCollection();
			MetaIndexCollection newIndexs = this.getIndexCollection();
			for (MetaIndex newIndex : newIndexs) {
				if (!oldIndexs.containsKey(newIndex.getKey())) {
					return true;
				}
			}
			
			return false;
		}
		return true;
	}
}
