package com.bokesoft.yigo.meta.report;

public class ReportSectionType {
	/** 页眉 */
	public static final int PAGE_HEAD = 0;
	/** 页眉字符中表示 */
	public static final String STR_PAGE_HEAD = "PageHead";
	
	/** 段落 */
	public static final int PARAGRAPH = 1;
	/** 段落字符串表示 */
	public static final String STR_PARAGRAPH = "Paragraph";
	
	/** 表格 */
	public static final int TABLE = 2;
	/** 表格字符串表示 */
	public static final String STR_TABLE = "Table";
	
	/** 页尾 */
	public static final int PAGE_TAIL = 3;
	/** 页尾字符串表示 */
	public static final String STR_PAGE_TAIL = "PageTail";
	
	public static int parse(String s) {
		int type = -1;
		if ( STR_PAGE_HEAD.equalsIgnoreCase(s) ) {
			type = PAGE_HEAD;
		} else if ( STR_PARAGRAPH.equalsIgnoreCase(s) ) {
			type = PARAGRAPH;
		} else if ( STR_TABLE.equalsIgnoreCase(s) ) {
			type = TABLE;
		} else if ( STR_PAGE_TAIL.equalsIgnoreCase(s) ) {
			type = PAGE_TAIL;
		}
		return type;
	}
	
	public static String toString(Integer type) {
		if(type == null)
			return "";
		
		String s = null;
		switch ( type ) {
		case PAGE_HEAD:
			s = STR_PAGE_HEAD;
			break;
		case PARAGRAPH:
			s = STR_PARAGRAPH;
			break;
		case TABLE:
			s = STR_TABLE;
			break;
		case PAGE_TAIL:
			s = STR_PAGE_TAIL;
			break;
		}
		return s;
	}
}
