package com.bokesoft.yigo.meta.report;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaReportRowGroup extends MetaBaseScript {
	/** 分组处理标志 */
	private String tag = "";
	/** 树结构标识 */
	private String itemKey = "";
	
	public MetaReportRowGroup() {
		super(TAG_NAME);
	}
	
	public static final String TAG_NAME = "RowGroup";
	
	/**
	 * 设置分组处理标志
	 * @param tag 分组处理标志
	 */
	public void setTag(String tag) {
		this.tag = tag;
	}
	
	/**
	 * 取得分组处理标志
	 * @return 分组处理标志
	 */
	public String getTag() {
		return this.tag;
	}
	
	/**
	 * 设置树结构标识
	 * @param itemKey 树结构标识
	 */
	public void setItemKey(String itemKey) {
		this.itemKey = itemKey;
	}
	
	/**
	 * 取得树结构标识
	 * @return 树结构标识
	 */
	public String getItemKey() {
		return this.itemKey;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaReportRowGroup newRowGroup = (MetaReportRowGroup) super.clone();
		newRowGroup.setTag(tag);
		newRowGroup.setItemKey(itemKey);
		return newRowGroup;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaReportRowGroup();
	}
}
