package com.bokesoft.yigo.meta.report;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaReportGridRow extends
		GenericNoKeyCollection<MetaReportGridCell> {
	public static final String TAG_NAME = "Row";

	/** 行高 */
	private Integer height = 0;
	/** 行类型 */
	private Integer type = -1;
	/** 背景色 */
	private String backColor = "";
	/** 来源的数据表标识 */
	private String tableKey = "";
	/** 是否允许断行 */
	private Boolean lineBreak = false;
	/** 是否分隔页 */
	private Boolean pageBreak = false;
	/** 行所属分组标识，关联明细行的分组单元格标识 */
	private String groupKey = "";
	/** 在树形分组下标识行所属的分组层级 */
	private Integer groupLevel = -1;
	/** 每页明细行数 */
	private Integer dtlCountEveryPage = 0;
	/** 行过滤 */
	private String filter = "";
	
	public MetaReportGridRow() {
		super();
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaReportGridCell.TAG_NAME)) {
			resultMetaObject = new MetaReportGridCell();
		}
		resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		add((MetaReportGridCell) resultMetaObject);
		return resultMetaObject;
	}

	/**
	 * 取得行高
	 * @return 行高
	 */
	public Integer getHeight() {
		return height;
	}

	/**
	 * 设置行高
	 * @param height 行高
	 */
	public void setHeight(Integer height) {
		this.height = height;
	}

	/**
	 * 取得行类型
	 * @return 行类型
	 */
	public Integer getType() {
		return type;
	}

	/**
	 * 设置行类型
	 * @param type 行类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}

	/**
	 * 取得背景色
	 * @return 背景色
	 */
	public String getBackColor() {
		return backColor;
	}

	/**
	 * 设置背景色
	 * @param backColor 背景色
	 */
	public void setBackColor(String backColor) {
		this.backColor = backColor;
	}
	
	/**
	 * 设置关联数据表标识
	 * @param tableKey 数据表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	/**
	 * 取得关联数据表标识
	 * @return 数据表标识
	 */
	public String getTableKey() {
		return this.tableKey;
	}
	
	/**
	 * 设置是否允许断行
	 * @param lineBreak 允许断行标志
	 */
	public void setLineBreak(Boolean lineBreak) {
		this.lineBreak = lineBreak;
	}
	
	/**
	 * 取得是否允许断行
	 * @return 允许断行标志
	 */
	public Boolean isLineBreak() {
		return this.lineBreak;
	}
	
	/**
	 * 获取是否分隔页
	 * @return
	 */
	public Boolean isPageBreak() {
		return pageBreak;
	}

	/**
	 * 设置是否分隔页
	 * @param pageBreak
	 */
	public void setPageBreak(Boolean pageBreak) {
		this.pageBreak = pageBreak;
	}
	
	/**
	 * 设置所属分组标识
	 * @param groupKey 所属分组标识
	 */
	public void setGroupKey(String groupKey) {
		this.groupKey = groupKey;
	}
	
	/**
	 * 取得所属分组标识
	 * @return 所属分组标识
	 */
	public String getGroupKey() {
		return this.groupKey;
	}
	
	/**
	 * 设置所属性分组层级
	 * @param groupLevel 分组层级
	 */
	public void setGroupLevel(Integer groupLevel) {
		this.groupLevel = groupLevel;
	}
	
	/**
	 * 取得所属分组层级
	 * @return 分组层级
	 */
	public Integer getGroupLevel() {
		return this.groupLevel;
	}
	
	/**
	 * 设置每页显示行数
	 * 
	 * @param dtlCountEveryPage 每页显示行数
	 */
	public void setDtlCountEveryPage(Integer dtlCountEveryPage) {
		this.dtlCountEveryPage = dtlCountEveryPage;
	}
	
	/**
	 * 获取每页显示行数
	 * @return 每页显示行数
	 */
	public Integer getDtlCountEveryPage() {
		return this.dtlCountEveryPage;
	}
	
	/**
	 * 获取行过滤条件
	 * @return
	 */
	public String getFilter() {
		return this.filter;
	}
	
	/**
	 * 设置行过滤条件
	 * @param filter
	 */
	public void setFilter(String filter) {
		this.filter = filter;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaReportGridRow();
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaReportGridRow newRow = (MetaReportGridRow) super.clone();
		newRow.setHeight(height);
		newRow.setType(type);
		newRow.setBackColor(backColor);
		newRow.setTableKey(tableKey);
		newRow.setLineBreak(lineBreak);
		newRow.setPageBreak(pageBreak);
		newRow.setGroupKey(groupKey);
		newRow.setGroupLevel(groupLevel);
		newRow.setDtlCountEveryPage(dtlCountEveryPage);
		newRow.setFilter(filter);
		return newRow;
	}
}
