package com.bokesoft.yigo.meta.report;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaReportColumnExpand extends MetaBaseScript {
	/** 扩展类型 */
	private Integer expandType = -1;
	/** 扩展来源类型 */
	private Integer sourceType = -1;
	/** 列标识 */
	private String columnKey = "";
	
	public MetaReportColumnExpand() {
		super(TAG_NAME);
	}
	
	public static final String TAG_NAME = "ColumnExpand";

	/**
	 * 设置扩展类型
	 * @param expandType 扩展类型
	 */
	public void setExpandType(Integer expandType) {
		this.expandType = expandType;
	}
	
	/**
	 * 取得扩展类型
	 * @return 扩展类型
	 */
	public Integer getExpandType() {
		return this.expandType;
	}
	
	/**
	 * 设置扩展源类型
	 * @param sourceType 扩展源类型
	 */
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}
	
	/**
	 * 取得扩展源类型
	 * @return 扩展源类型
	 */
	public Integer getSourceType() {
		return this.sourceType;
	}
	
	/**
	 * 设置列标识
	 * @param columnKey 列标识
	 */
	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}
	
	/**
	 * 取得列标识
	 * @return 列标识
	 */
	public String getColumnKey() {
		return this.columnKey;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaReportColumnExpand newColumnExpand = (MetaReportColumnExpand) super.clone();
		newColumnExpand.setExpandType(expandType);
		newColumnExpand.setSourceType(sourceType);
		newColumnExpand.setColumnKey(columnKey);
		return newColumnExpand;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaReportColumnExpand();
	}
}
