package com.bokesoft.yigo.meta.path;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaRelationList extends GenericKeyCollection<MetaRelationProfile> implements IElementMerge<MetaRelationList> {

	public String getKey(int type, String formkey, String targetkey) {
		for (MetaRelationProfile pro : this) {
			if (pro.getType() != type)
				continue;
			if (!pro.getTargetkey().equalsIgnoreCase(targetkey))
				continue;
			if (!pro.getFormkey().equalsIgnoreCase(formkey))
				continue;
			return pro.getKey();
		}
		return null;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return null;
	}

	@Override
	public MetaRelationList toMerge(MetaRelationList obj) {
		if (obj != null) {
			Iterator<MetaRelationProfile> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaRelationProfile metaRelationProfile = (MetaRelationProfile) iterator.next();
				if (containsKey(metaRelationProfile.getKey())) {
					throw new MetaException(MetaException.REPEAT_RELATION_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatRelationDefined),
									metaRelationProfile.getProject().getKey(), "", metaRelationProfile.getKey()));
				}
				add(metaRelationProfile);
			}
		}
		return this;
	}

}
