package com.bokesoft.yigo.meta.mobiledef;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaFormat;

public class MetaWatermark extends AbstractMetaObject {

	/** 格式 */
	private MetaFormat format;

	/** 旋转角度，顺时针计算 */
	private Float rotate = -30f;

	/** 密度 单位dp */
	private Integer density = 50;

	private String formulaText;


	public static final String TAG_NAME = "Watermark";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 取得格式
	 * 
	 * @return 格式
	 */
	public MetaFormat getFormat() {
		return format;
	}

	/**
	 * 设置格式
	 * 
	 * @param 格式
	 * 
	 */
	public void setFormat(MetaFormat format) {
		this.format = format;
	}

	/**
	 * 取得旋转角度
	 * 
	 * @return 旋转角度
	 */
	public Float getRotate() {
		return rotate;
	}

	/**
	 * 设置旋转角度
	 * 
	 * @param 旋转角度
	 */
	public void setRotate(Float rotate) {
		this.rotate = rotate;
	}

	/**
	 * 取得密度
	 * 
	 * @return 密度
	 */
	public Integer getDensity() {
		return density;
	}

	/**
	 * 设置密度
	 * 
	 * @param 密度
	 */
	public void setDensity(Integer density) {
		this.density = density;
	}
	
	public String getFormulaText() {
		return formulaText;
	}

	public void setFormulaText(String formulaText) {
		this.formulaText = formulaText;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( format != null ) {
			list.add(format);
		}
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		if ( format != null ) {
			format.doPostProcess(flag, callback);
		}
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equals(MetaFormat.TAG_NAME)) {
			format = new MetaFormat();
			resultMetaObject = format;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaWatermark watermark = (MetaWatermark) newInstance();
		watermark.setDensity(density);
		watermark.setFormat(format == null ? null : (MetaFormat) format.clone());
		watermark.setRotate(rotate);
		watermark.setFormulaText(formulaText);
		return watermark;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaWatermark();
	}
}