package com.bokesoft.yigo.meta.form.component.view.layout;

import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaLinearItem extends MetaLayoutItem{
	public static final String TAG_NAME = "LinearItem";
	private DefSize height = null;
	private DefSize width = null;
	/** android线性布局 权重 */
	private Float weight = 0.0f;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	public void setHeight(DefSize height) {
		this.height = height;
	}
	
	public DefSize getHeight() {
		return this.height;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaLinearItem newObj = (MetaLinearItem)super.clone();
		newObj.setHeight(height);
		newObj.setWidth(width);
		newObj.setWeight(weight);
		return newObj;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaLinearItem();
	}

	public final DefSize getWidth() {
		return width;
	}

	public final void setWidth(DefSize width) {
		this.width = width;
	}

	public final Float getWeight() {
		return weight;
	}

	public final void setWeight(Float weight) {
		this.weight = weight;
	}
	
}
