package com.bokesoft.yigo.meta.form.component.view.layout;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitSizeCollapaseTypeEnum;

public class MetaLayoutSplitItem extends MetaLayoutItem {
	/** 拆分大小 */
	private DefSize size = null;
	Integer collapaseType = MetaSplitSizeCollapaseTypeEnum.DEFAULT.getType();
	Boolean forwardCollapased = false;
	Boolean reverseCollapased = false;
	public MetaLayoutSplitItem() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public Integer getType() {
		return collapaseType;
	}

	public void setType(Integer type) {
		this.collapaseType = type;
	}

	public Boolean getForwardCollapased() {
		return forwardCollapased;
	}

	public void setForwardCollapased(Boolean forwardCollapased) {
		this.forwardCollapased = forwardCollapased;
	}

	public Boolean getReverseCollapased() {
		return reverseCollapased;
	}

	public void setReverseCollapased(Boolean reverseCollapased) {
		this.reverseCollapased = reverseCollapased;
	}

	public static final String TAG_NAME = "LayoutSplitItem";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置拆分大小
	 * @param size 拆分大小
	 */
	public void setSize(DefSize size) {
		this.size = size;
	}
	
	/**
	 * 取得拆分大小
	 * @return 拆分大小
	 */
	public DefSize getSize() {
		return this.size;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaLayoutSplitItem newObject = (MetaLayoutSplitItem)super.clone();
		newObject.setSize(size);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaLayoutSplitItem();
	}

}
