package com.bokesoft.yigo.meta.form.component.theme;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaThemeCollection extends GenericKeyCollection<MetaTheme> {
	private String defaultTheme = "";
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}
	
	public void setDefaultTheme(String defaultTheme) {
		this.defaultTheme = defaultTheme;
	}
	
	public String getDefaultTheme() {
		return this.defaultTheme;
	}

	public static final String TAG_NAME = "ThemeCollection";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		MetaTheme metaTheme = new MetaTheme();
		metaTheme.preProcessMetaObject(env, doc, node, flag, runType);
		this.add(metaTheme);
		return metaTheme;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaThemeCollection();
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		Iterator<MetaTheme> it = this.iterator();
		MetaTheme metaTheme = null;
		while ( it.hasNext() ) {
			metaTheme = it.next();
			metaTheme.doPostProcess(flag, callback);
		}
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaThemeCollection newThemeCollection = (MetaThemeCollection) super.clone();
		newThemeCollection.setDefaultTheme(defaultTheme);
		return newThemeCollection;
	}
}
