package com.bokesoft.yigo.meta.form.component.panel.gridpanel;/*
 *文件名: MetaGroup
 *创建者: zhangk
 *创建时间:2022/9/10 15:04
 */

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

import java.util.LinkedList;

public class MetaGroup extends KeyPairMetaObject implements Cloneable, IPropertyMerger<MetaGroup> {

	public static final String TAG_NAME = "Group";
	//处理方式
	private MetaHandle metaHandle = null;
	//key
	private String key = "";
	//名称
	private String caption = "";
	//默认展开分组
	private String expanded = "";
	//开始行
	private Integer startRow = -1;
	//结束行
	private Integer endRow = -1;

	public MetaHandle getMetaHandle() {
		return metaHandle;
	}

	@Override
	public void setKey(String key) {
		this.key = key;
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getExpanded() {
		return expanded;
	}

	public void setExpanded(String expanded) {
		this.expanded = expanded;
	}

	public Integer getStartRow() {
		return startRow;
	}

	public void setStartRow(Integer startRow) {
		this.startRow = startRow;
	}

	public Integer getEndRow() {
		return endRow;
	}

	public void setEndRow(Integer endRow) {
		this.endRow = endRow;
	}

	public void setMetaHandle(MetaHandle metaHandle) {
		this.metaHandle = metaHandle;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(metaHandle);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject metaObj = null;
		if (MetaHandle.TAG_NAME.equals(tagName)) {
			metaHandle = new MetaHandle();
			metaObj = metaHandle;
		}
		return metaObj;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGroup newInstance = (MetaGroup) newInstance();
		newInstance.setMetaHandle(metaHandle);
		newInstance.setKey(key);
		newInstance.setExpanded(expanded);
		newInstance.setEndRow(endRow);
		newInstance.setStartRow(startRow);
		newInstance.setCaption(caption);
		return newInstance;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGroup();
	}


	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void merge(MetaGroup metaGroup) {
		if (this.caption == null) {
			this.caption = metaGroup.getCaption();
		}
		if (this.startRow == null) {
			this.startRow = metaGroup.getStartRow();
		}
		if (this.endRow == null) {
			this.endRow = metaGroup.getEndRow();
		}
		if (this.expanded == null) {
			this.expanded = metaGroup.getExpanded();
		}
		if (this.metaHandle == null) {
			this.metaHandle = metaGroup.getMetaHandle();
		} else {
			this.metaHandle.merge(metaGroup.getMetaHandle());
		}

	}
}
