package com.bokesoft.yigo.meta.form.component.panel.gridpanel;/*
 *文件名: MetaExtraLayout
 *创建者: zhangk
 *创建时间:2022/9/10 7:24
 *描述：额外布局
 */

import com.bokesoft.yigo.common.def.ExtraLayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

import java.util.LinkedList;

public class MetaExtraLayout extends AbstractMetaObject implements Cloneable, IPropertyMerger<MetaExtraLayout> {

	public static final String TAG_NAME = "ExtraLayout";
	//面板收缩,属性面板
	Integer type = ExtraLayoutType.COLLAPSIBLE;

	private MetaGroupCollection metaGroupCollection = null;

	public MetaGroupCollection getMetaGroupCollection() {
		return metaGroupCollection;
	}

	public void setMetaGroupCollection(MetaGroupCollection metaGroupCollection) {
		this.metaGroupCollection = metaGroupCollection;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public MetaExtraLayout() {
		super();
		this.metaGroupCollection = new MetaGroupCollection();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if (metaGroupCollection != null) {
			list.add(metaGroupCollection);
		}

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaGroupCollection.TAG_NAME.equals(tagName)) {
			metaGroupCollection = new MetaGroupCollection();
			resultMetaObject = metaGroupCollection;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaExtraLayout newObject = (MetaExtraLayout) newInstance();
		newObject.setType(type);
		newObject.setMetaGroupCollection(metaGroupCollection);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtraLayout();
	}

	@Override
	public void merge(MetaExtraLayout metaExtraLayout) {
		if (this.type == -1) {
			this.type = metaExtraLayout.getType();
		}
		if (this.metaGroupCollection == null) {
			this.metaGroupCollection = metaExtraLayout.getMetaGroupCollection();
		} else {
			this.metaGroupCollection.merge(metaExtraLayout.getMetaGroupCollection());
		}
	}
}
