package com.bokesoft.yigo.meta.form.component.panel;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSplitItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaSplitLayout;

/**
 * 拆分布局面板对象，属于布局类控件
 *
 * @author chenzs
 *
 */
public class MetaSplitPanel extends MetaPanel {

    /** 配置文件中对应节点的标签名称 */
    public static final String TAG_NAME = ControlType.STR_SPLITPANEL;

    /** 拆分面板的拆分方向，取值为Horizontal和Vertical */
    private Integer orientation = OrientationType.Horizontal;

    private MetaSplitSizeCollection splitSizeArray = null;

    public MetaSplitPanel() {
        super();
        splitSizeArray = new MetaSplitSizeCollection();
    }

    /**
     * 设置拆分方向
     *
     * @param orientation
     *            拆分方向
     */
    public void setOrientation(Integer orientation) {
        this.orientation = orientation;
    }

    /**
     * 获取拆分方向
     *
     * @return 拆分方向
     */
    public Integer getOrientation() {
        return orientation;
    }

    public void setSplitSize(MetaSplitSizeCollection splitSizeArray) {
        this.splitSizeArray = splitSizeArray;
    }

    public MetaSplitSizeCollection getSplitSize() {
        return this.splitSizeArray;
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public int getControlType() {
        return ControlType.SPLITPANEL;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        super.getChildMetaObjects(list);
        for (MetaSplitSize size : splitSizeArray) {
            list.add(size);
        }
        //addAll(list, new AbstractMetaObject[] {splitSizeArray});
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
                                                    String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject resultMetaObject = null;
        if ( MetaSplitSize.TAG_NAME.equals(tagName) ) {
            resultMetaObject = new MetaSplitSize();
            this.splitSizeArray.add((MetaSplitSize)resultMetaObject);
        }
        if ( resultMetaObject == null ) {
            resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
        }
        return resultMetaObject;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaSplitPanel newObject = (MetaSplitPanel)super.clone();
        newObject.setOrientation(orientation);
        MetaSplitSize size = null;
        MetaSplitSizeCollection newSplitSizeArray = new MetaSplitSizeCollection();
        Iterator<MetaSplitSize> it = splitSizeArray.iterator();
        while ( it.hasNext() ) {
            size = it.next();
            MetaSplitSize newSize = (MetaSplitSize)size.clone();
            newSplitSizeArray.add(newSize);
        }
        newObject.setSplitSize(newSplitSizeArray);

        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaSplitPanel();
    }

    @Override
    public MetaSplitLayout newLayout() {
        MetaSplitLayout layout = new MetaSplitLayout();
        layout.setOrientation(orientation);

        int size = this.componentArray.size();
        for ( int i = 0; i<size; ++i ) {
            MetaComponent metaComponent = this.componentArray.get(i);
            MetaLayoutSplitItem item = new MetaLayoutSplitItem();
            item.setKey(metaComponent.getKey());

            if ( i < splitSizeArray.size() && i < size ) {
                item.setSize(splitSizeArray.get(i).getSize());
                item.setType(splitSizeArray.get(i).getType());
                item.setForwardCollapased(splitSizeArray.get(i).getForwardCollapased());
                item.setReverseCollapased(splitSizeArray.get(i).getReverseCollapased());
            }
            layout.add(item);
        }

        return layout;
    }

    @Override
    public AbstractMetaObject getProperties() {
        return null;
    }

    @Override
    public void merge(MetaComponent meta) {
        super.merge(meta);

        MetaSplitPanel metaPanel = (MetaSplitPanel)meta;

        if( this.orientation == -1 ) {
            this.orientation = metaPanel.getOrientation();
        }
        MetaSplitSizeCollection splitSizeArray2 = metaPanel.getSplitSize();
        //noinspection DuplicatedCode
        if (splitSizeArray == null){
            splitSizeArray = splitSizeArray2;
        }else {
            int size = splitSizeArray.size();
            int size2 = splitSizeArray2.size();
            int maxSize = Math.max(size, size2);
            for (int i = size; i < maxSize; i++) {
                splitSizeArray.add(splitSizeArray2.get(i));
            }
            for (int i = size2; i < maxSize; i++) {
                splitSizeArray2.add(splitSizeArray.get(i));
            }
        }

    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        for(int i=0;i<componentArray.size();i++){
            try{
                MetaSplitSize metaSplitSize = splitSizeArray.get(i);
                if(metaSplitSize == null || metaSplitSize.getSize() == null){
                    throw new MetaException(MetaException.NO_DEFINITION_OF_SIZE, SimpleStringFormat.format(
                            StringTable.getString(null, "", StringTable.NoDefinitionOfSize), getKey(), componentArray.get(i).getKey()));
                }
            }catch (IndexOutOfBoundsException e){
                throw new MetaException(MetaException.NO_DEFINITION_OF_SIZE, SimpleStringFormat.format(
                        StringTable.getString(null, "", StringTable.NoDefinitionOfSize), getKey(), componentArray.get(i).getKey()));
            }
        }
    }
}
