package com.bokesoft.yigo.meta.form.component.html;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaHtml_UL extends MetaHtmlElement {
	private ArrayList<MetaHtml_LI> liArray = null;
	public MetaHtml_UL() {
		super();
		liArray = new ArrayList<MetaHtml_LI>();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		if ( liArray != null ) {
			list.add(liArray);
		}
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( resultMetaObject == null ) {
			if ( MetaHtml_LI.TAG_NAME.equals(tagName) ) {
				MetaHtml_LI li = new MetaHtml_LI();
				resultMetaObject = li;
				liArray.add(li);
			}
		}
		return resultMetaObject;
	}
	
	@Override
	public int getControlType() {
		return ControlType.HTML_ELEMENT_UL;
	}

	public static final String TAG_NAME = ControlType.STR_HTML_ELEMENT_UL;
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	public void addLi(MetaHtml_LI li) {
		liArray.add(li);
	}
	
	public void setLiArray(ArrayList<MetaHtml_LI> liArray) {
		this.liArray = liArray;
	}
	
	public ArrayList<MetaHtml_LI> getLiArray() {
		return this.liArray;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaHtml_UL newObject = (MetaHtml_UL) super.clone();
		MetaHtml_LI li = null;
		Iterator<MetaHtml_LI> it = liArray.iterator();
		while ( it.hasNext() ) {
			li = it.next();
			newObject.addLi((MetaHtml_LI)li.clone());
		}
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaHtml_UL();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}

}
