package com.bokesoft.yigo.meta.form.component.grid;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaFont;

public class MetaGridCellFormat extends AbstractMetaObject {
	/** 水平对齐 */
	private Integer hAlign = HAlignment.LEFT;
	/** 垂直对齐 */
	private Integer vAlign = VAlignment.CENTER;
	/** 左边框标志 */
	private Boolean leftBorder = false;
	/** 顶边框标志 */
	private Boolean topBorder = false;
	/** 右边框标志 */
	private Boolean rightBorder = false;
	/** 底边框标志 */
	private Boolean bottomBorder = false;
	/** 字体*/
	private MetaFont font = null;
	
	public MetaGridCellFormat() {
		super();
	}

	public static final String TAG_NAME = "CellFormat";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( font != null ) {
			list.add(font);
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaFont.TAG_NAME.equals(tagName) ) {
			font = new MetaFont();
			resultMetaObject = font;
		}
		return resultMetaObject;
	}
	
	/**
	 * 设置水平对齐方式
	 * @param hAlign 对齐方式
	 */
	public void setHAlign(Integer hAlign) {
		this.hAlign = hAlign;
	}
	
	/**
	 * 取得水平对齐方式
	 * @return 对齐方式
	 */
	public Integer getHAlign() {
		return this.hAlign;
	}
	
	/**
	 * 设置垂直对齐方式
	 * @param vAlign 对齐方式
	 */
	public void setVAlign(Integer vAlign) {
		this.vAlign = vAlign;
	}
	
	/**
	 * 取得垂直对齐方式
	 * @return 对齐方式
	 */
	public Integer getVAlign() {
		return this.vAlign;
	}
	
	/**
	 * 设置左边框
	 * @param leftBorder 标志
	 */
	public void setLeftBorder(Boolean leftBorder) {
		this.leftBorder = leftBorder;
	}
	
	/**
	 * 取得是否有边框
	 * @return 标志
	 */
	public Boolean isLeftBorder() {
		return this.leftBorder;
	}
	
	/**
	 * 设置顶边框
	 * @param topBorder 标志
	 */
	public void setTopBorder(Boolean topBorder) {
		this.topBorder = topBorder;
	}
	
	/**
	 * 取得顶边框标志
	 * @return 标志
	 */
	public Boolean isTopBorder() {
		return this.topBorder;
	}
	
	/**
	 * 设置右边框
	 * @param rightBorder 标志
	 */
	public void setRightBorder(Boolean rightBorder) {
		this.rightBorder = rightBorder;
	}
	
	/**
	 * 取得右边框标志
	 * @return 标志
	 */
	public Boolean isRightBorder() {
		return this.rightBorder;
	}
	
	/**
	 * 设置底边框
	 * @param bottomBorder 标志
	 */
	public void setBottomBorder(Boolean bottomBorder) {
		this.bottomBorder = bottomBorder;
	}
	
	/**
	 * 取得底边框标志
	 * @return 标志
	 */
	public Boolean isBottomBorder() {
		return this.bottomBorder;
	}
	
	/**
	 * 设置字体
	 * @param font
	 */
	public void setFont(MetaFont font) {
		this.font = font;
	}
	
	/**
	 * 获取字体
	 * @return
	 */
	public MetaFont getFont() {
		return this.font;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGridCellFormat newObject = (MetaGridCellFormat)newInstance();
		newObject.setHAlign(hAlign);
		newObject.setVAlign(vAlign);
		newObject.setLeftBorder(leftBorder);
		newObject.setTopBorder(topBorder);
		newObject.setRightBorder(rightBorder);
		newObject.setBottomBorder(bottomBorder);
		newObject.setFont(font == null ? null : (MetaFont)font.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGridCellFormat();
	}

}
