package com.bokesoft.yigo.meta.form.component.grid;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map.Entry;

import com.bokesoft.yes.common.struct.MultiKey;
import com.bokesoft.yes.common.struct.MultiKeyNode;
import com.bokesoft.yes.common.struct.report.MultiDimValue;
import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDynamicProperties;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.GroupType;
import com.bokesoft.yigo.common.def.SortType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaCustomData;
import com.bokesoft.yigo.meta.form.IPropertiesElement;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.MetaShortCutCollection;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.properties.*;

/**
 * MetaGridCell定义格行中一个单元格的描述信息，包括以下属性：
 * <ul>
 * <li>单元格标识
 * <li>单元格名称
 * <li>单元格绑定的界面组件类型
 * <li>单元格的合并信息
 * <li>单元格的分组信息
 * <li>单元格的数据绑定信息
 * </ul>
 * @author 王元和
 * @since YES 1.0
 */
public class MetaGridCell extends KeyPairMetaObject implements IPropertiesElement,IDimValueAware,IMetaColumnExpandObject,IPropertyMerger<MetaGridCell>{
    /**
     *
     */
    private static final long serialVersionUID = 1L;
    /** 单元格标识 */
    private String key = "";
    /** 单元格名称 */
    private String caption = "";
    /** 单元格名称全称 */
    private String captionFull = "";
    /** 单元格英文名称**/
    private String captionEn = "";
    /** 单元格英文名称全称**/
    private String captionEnFull = "";
    /** 单元格可用性，表达式，默认值为null，表示未定义 */
    private String enable = "";
    /** 单元格可见性，表达式，默认值为null，表示未定义 */
	private String visible = "";
    /** 可用性依赖的组件标识*/
    private String enableDependency = "";
	/** 单元格的绑定界面组件类型，取值范围见{@link ControlType} */
    private Integer cellType = ControlType.LABEL;
    /** 是否在合并区域 */
    private Boolean isMerged = false;
    /** 是否合并区域头 */
    private Boolean isMergedHead = false;
    /** 合并行数，只对isMergedHead为true的单元格有效,-1表示未定义*/
    private Integer mergedRowSpan = 1;
    /** 合并列数，只对isMergedHead为true的单元格有效,-1表示未定义*/
    private Integer mergedColumnSpan = 1;
	/** 分组类型，取值范围见{@link GroupType},-1表示未定义*/
    private Integer cellGroupType = GroupType.None;
    /** 是否选择字段 */
    private Boolean isSelect = false;
    /** 选择字段是否单选*/
    private Boolean singleSelect = false;
    /** 数据绑定对象 */
    private MetaDataBinding dataBinding = null;
    /** 单元格组件属性 */
    private AbstractMetaObject properties = null;
    /**行分组元数据对象*/
    private MetaRowGroup rowGroup = null;
    /** 二次开发自定义描述 */
    private MetaCustomData customData = null;
    /** 单元格格式 */
    private MetaGridCellFormat format = null;
    /** 双击事件*/
    private MetaBaseScript dblClick = null;
    /** 快捷键*/
    private MetaShortCutCollection shortCutCollection = null;
    /** 单元格列拓展*/
    private MetaColumnExpand columnExpand = null;
    /** css类名 */
    private String cssClass = "";
    /** 前景色 */
    private String foreColor = "";
    /** 背景色 */
    private String backColor = "";
    /** 排序类型 */
    private Integer cellSortType = SortType.Asc;
    /** 树形分组依赖的字典标识 */
    private String cellGroupItemKey = "";
    /** 填报报表使用的关键词(维度)定义,定义在明细行,预处理转成dimValue*/
    private String keywords = "";
    /** 相同值单元格合并,明细行使用*/
    private Boolean merge = false;
    /** 是否合并分组行,在merge属性为true时有效*/
    private Boolean mergeGroup = false;
    /** 是否为叙时簿查询字段  */
    private Boolean asQuery = false;

    /** 是否可复制新增*/
    private Boolean copynew = true;
    //第一个
    private String sideKey = "";
    //是否插入之后
    private Boolean insertAfter = null;

    private Boolean first = false;
    private Boolean last = false;

    public Boolean getInsertAfter() {
        return insertAfter;
    }

    public void setInsertAfter(Boolean insertAfter) {
        this.insertAfter = insertAfter;
    }

    public String getSideKey() {
        return sideKey;
    }

    public void setSideKey(String sideKey) {
        this.sideKey = sideKey;
    }

    /** ----------------------------------------------------------------------
     * 派生属性开始，这部分信息用于根据现有的配置信息进行而来，目的是为了代码逻辑处理方便
     */
    private MetaGridCellCalcMergeInfo calcMergeInfo = null;
    /** 多层拓展用于存储不同的列拓展与其对应的拓展值(有顺序)*/
    private LinkedHashMap<String,MultiKeyNode> crossValueMap = null;
    /** 维度数据,用于列拓展*/
    private MultiKey crossValue = null;
    /** 维度数据,用于填报报表*/
    private MultiDimValue dimValue = null;
    /** 拓展属性*/
    private MetaGridCellExtendInfo extendInfo = null;
    /** 是否有数据绑定 */
    private boolean hasDataBinding = false;
    /** 是否是马甲新增的字段 */
    private boolean isNewExtField = false;
    /**是否是马甲删除字段**/
    private boolean isVestDeleteCol = false;

    /** 是否访问控制,预处理好,计算直接取用*/
    private boolean accessControl = false;
    /** 来自于数据源的默认值*/
    private String dsDefaultValue = "";
    private HashMap extendJson = new HashMap();

    /**
     * 派生属性结束
     */

    /** 鼠标放置时的提示信息 */
    private String tip = "";

    /** 控件的鼠标放置时的提示信息, 可动态使用表达式赋值 */
    private String formulaTip = "";

    public MetaGridCell() {
        super();
    }

    /**
     * 设置鼠标放置提示信息
     *
     * @param tip
     *            提示信息
     */
    public void setToolTip(String tip) {
        this.tip = tip;
    }

    public Boolean getFirst() {
        return first;
    }

    public void setFirst(Boolean first) {
        this.first = first;
    }

    public Boolean getLast() {
        return last;
    }

    public void setLast(Boolean last) {
        this.last = last;
    }

    /**
     * 获取鼠标放置提示信息
     *
     * @return 提示信息
     */
    public String getToolTip() {
        return this.tip;
    }

    /**
     * 设置控件的鼠标放置提示信息, 可动态使用表达式赋值
     *
     * @param formulaTip
     *            提示信息
     */
    public void setFormulaTip(String formulaTip) {
        this.formulaTip = formulaTip;
    }

    /**
     * 获取控件的鼠标放置提示信息, 可动态使用表达式赋值
     *
     * @return 提示信息
     */
    public String getFormulaTip() {
        return this.formulaTip;
    }

    /**
     * 是否访问控制
     * @return
     */
    public boolean isAccessControl() {
        return accessControl;
    }

    /**
     * 设置是否访问控制
     * @param accessControl 是否访问控制
     */
    public void setAccessControl(boolean accessControl) {
        this.accessControl = accessControl;
    }

    /**
     * 获取可用性依赖
     * @return 可用性依赖
     */
    public String getEnableDependency() {
        return enableDependency;
    }

    /**
     * 设置可用性依赖
     * @param enableDependency 可用性依赖
     */
    public void setEnableDependency(String enableDependency) {
        this.enableDependency = enableDependency;
    }

    /**
     * 获取列拓展定义
     * @return 列拓展定义
     */
    @Override
    public MetaColumnExpand getColumnExpand() {
        return columnExpand;
    }

    /**
     * 设置列拓展定义
     * @param columnExpand 列拓展定义
     */
    public void setColumnExpand(MetaColumnExpand columnExpand) {
        this.columnExpand = columnExpand;
    }

    /**
     * 获取是否为必填项
     *
     * @return 是否为必填项标志
     */
    public Boolean isRequired() {
        return this.dataBinding == null ? null : this.dataBinding.isRequired();
    }
    public boolean isVestDeleted() {
        return isVestDeleteCol;
    }

    /**
     * 设置是否是马甲删除字段
     *
     * @param isVestDeleteCol
     */
    public void setIsVestDeleteCol(boolean isVestDeleteCol) {
        this.isVestDeleteCol = isVestDeleteCol;
    }


    /**
     * 获取是否合并相同值
     * @return 标志
     */
    public Boolean isMerge() {
        return merge;
    }

    /**
     * 设置是否合并相同值
     * @param merge 标志
     */
    public void setMerge(Boolean merge) {
        this.merge = merge;
    }

    /**
     * 是否合并分组行
     * @return
     */
    public Boolean isMergeGroup() {
        return mergeGroup;
    }

    /**
     * 设置是否合并分组
     * @param mergeGroup
     */
    public void setMergeGroup(Boolean mergeGroup) {
        this.mergeGroup = mergeGroup;
    }

    /**
     * 取得行分组定义
     * @return 行分组定义
     */
    public MetaRowGroup getRowGroup() {
        return rowGroup;
    }

    /**
     * 设置行分组定义
     * @param gridRowGroup 行分组定义
     */
    public void setRowGroup(MetaRowGroup gridRowGroup) {
        this.rowGroup = gridRowGroup;
    }

    /**
     * 设置属性定义
     * @param properties 属性定义
     */
    public void setProperties(AbstractMetaObject properties) {
        this.properties = properties;
    }

    public boolean isNewExtField() {
        return isNewExtField;
    }

    public void setNewExtField(boolean newExtField) {
        isNewExtField = newExtField;
    }
    /**
     * 取得属性定义，如果为null创建一个属性定义并返回
     * @return 属性定义
     */
    @Override
    public AbstractMetaObject getProperties() {
        if( properties == null ){
            ensureProperties();
        }
        return properties;
    }

    @Override
    public int getElementType() {
        return getCellType();
    }

    public HashMap getExtendJson() {
        return extendJson;
    }

    public void setExtendJson(HashMap extendJson) {
        this.extendJson = extendJson;
    }

    /**
     * 取得属性定义，如果为null创建一个属性定义并返回
     */
    public void ensureProperties() {
        if ( properties == null ) {
            switch ( this.cellType ) {
                case ControlType.LABEL:
                    this.properties = new MetaLabelProperties();
                    break;
                case ControlType.PRICELABEL:
                    this.properties = new MetaPriceLabelProperties();
                    break;
                case ControlType.RELATIVETIME:
                    this.properties = new MetaRelativeTimeProperties();
                    break;
                case ControlType.CHECKBOX:
                    this.properties = new MetaCheckBoxProperties();
                    break;
                case ControlType.RADIOBUTTON:
                    this.properties = new MetaRadioButtonProperties();
                    break;
                case ControlType.HYPERLINK:
                    this.properties = new MetaHyperLinkProperties();
                    break;
                case ControlType.BUTTON:
                case ControlType.IMAGEBUTTON:
                    this.properties = new MetaButtonProperties();
                    break;
                case ControlType.NOTICEBAR:
                    this.properties = new MetaNoticeBarProperties();
                    break;
                case ControlType.BARCODER:
                    this.properties = new MetaBarCoderProperties();
                    break;
                case ControlType.TOGGLEBUTTON:
                    this.properties = new MetaToggleButtonProperties();
                    break;
                case ControlType.MULTISTATEBUTTON:
                    this.properties = new MetaMultiStateButtonProperties();
                    break;
                case ControlType.TEXTEDITOR:
                    this.properties = new MetaTextEditorProperties();
                    break;
                case ControlType.TEXTBUTTON:
                    this.properties = new MetaTextButtonProperties();
                    break;
                case ControlType.NUMBEREDITOR:
                    this.properties = new MetaNumberEditorProperties();
                    break;
                case ControlType.DICT:
                case ControlType.COMPDICT:
                case ControlType.DYNAMICDICT:
                    this.properties = new MetaDictProperties();
                    break;
                case ControlType.DATEPICKER:
                    this.properties = new MetaDatePickerProperties();
                    break;
                case ControlType.UTCDATEPICKER:
                    this.properties = new MetaUTCDatePickerProperties();
                    break;
                case ControlType.COMBOBOX:
                    this.properties = new MetaComboBoxProperties();
                    break;
                case ControlType.CHECKLISTBOX:
                    this.properties = new MetaCheckListBoxProperties();
                    break;
                case ControlType.IMAGE:
                    this.properties = new MetaImageProperties();
                    break;
                case ControlType.VIDEOPLAYER:
                    this.properties = new MetaVideoPlayerProperties();
                    break;
                case ControlType.STEPEDITOR:
                    this.properties = new MetaStepEditorProperties();
                    break;
                case ControlType.ICON:
                    this.properties = new MetaIconProperties();
                    break;
                case ControlType.CUSTOM:
                    this.properties = new MetaCustomProperties();
                    break;
                case ControlType.DYNAMIC:
                    this.properties = new MetaDynamicProperties();
                    break;
                case ControlType.TEXTAREA:
                    this.properties = new MetaTextAreaProperties();
                    break;
                case ControlType.PASSWORDEDITOR:
                    this.properties = new MetaPasswordEditorProperties();
                    break;
                case ControlType.NUMBERINFOEDITOR:
                    this.properties = new MetaNumberInfoEditorProperties();
                    break;
                case ControlType.SCOREBAR:
                    this.properties = new MetaScoreBarProperties();
                    break;
                case ControlType.SWITCH:
                    this.properties = new MetaSwitchProperties();
                    break;
                case ControlType.SEGMENTEDCONTROL:
                    this.properties = new MetaSegmentedControlProperties();
                    break;
                case ControlType.PROGRESSINDICATOR:
                    this.properties = new MetaProgressIndicatorProperties();
                    break;
                case ControlType.PROGRESSBAR:
                    this.properties = new MetaProgressBarProperties();
                    break;
                case ControlType.SLIDER:
                    this.properties = new MetaSliderProperties();
                    break;
                case ControlType.COUNTDOWNVIEW:
                    this.properties = new MetaCountDownViewProperties();
                    break;
                case ControlType.GIFIMAGE:
                    this.properties = new MetaGIFImageProperties();
                    break;
                case ControlType.IMAGELIST:
                    this.properties = new MetaImageListProperties();
                    break;
                case ControlType.EMPTY:
                    this.properties = new MetaEmptyProperties();
                    break;
                case ControlType.MONTHPICKER:
                    this.properties = new MetaMonthPickerProperties();
                    break;
                case ControlType.TIMEPICKER:
                    this.properties = new MetaTimePickerProperties();
                    break;
                case ControlType.UPLOADBUTTON:
                    this.properties = new MetaUploadButtonProperties();
                    break;
                case ControlType.COUNTUP:
                    this.properties = new MetaCountUpProperties();
                    break;
                case ControlType.WIZARDLIST:
                    this.properties = new MetaWizardListProperties();
                    break;
                case ControlType.TIMECOUNTDOWN:
                    this.properties = new MetaTimeCountDownProperties();
                    break;
                default:
                    throw new RuntimeException("表格字段"+this.key+"控件类型错误，请修改！");
            }
        }
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        if ( dataBinding != null ) {
            list.add(dataBinding);
        }
        if ( properties != null ) {
            properties.getChildMetaObjects(list);
        }
        if ( rowGroup != null ) {
            list.add(rowGroup);
        }
        if ( dblClick != null ) {
            list.add(dblClick);
        }
        if ( shortCutCollection != null ) {
            list.add(shortCutCollection);
        }
        if ( format != null ) {
            list.add(format);
        }
        if( customData != null ) {
            list.add(customData);
        }
        if( columnExpand != null ) {
            list.add(columnExpand);
        }
    }

    public static final String TAG_NAME = "GridCell";

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
                                                    String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject resultMetaObject = null;
        if ( this.properties != null ) {
            resultMetaObject = this.properties.createChildMetaObject(env, doc, node, tagName, flag, runType);
        }
        if ( MetaRowGroup.TAG_NAME.equals(tagName) ) {
            rowGroup = new MetaRowGroup();
            resultMetaObject = rowGroup;
        } else if ( MetaDataBinding.TAG_NAME.equals(tagName) ) {
            this.dataBinding = new MetaDataBinding();
            resultMetaObject = this.dataBinding;
        } else if ( MetaConstants.Event_CellDblClick.equals(tagName) ) {
            this.dblClick = new MetaBaseScript(MetaConstants.Event_CellDblClick);
            resultMetaObject = this.dblClick;
        } else if ( MetaShortCutCollection.TAG_NAME.equals(tagName) ) {
            this.shortCutCollection = new MetaShortCutCollection();
            resultMetaObject = this.shortCutCollection;
        } else if ( MetaCustomData.TAG_NAME.equals(tagName) ) {
            this.customData = new MetaCustomData();
            resultMetaObject = this.customData;
        } else if ( MetaGridCellFormat.TAG_NAME.equals(tagName) ) {
            this.format = new MetaGridCellFormat();
            resultMetaObject = this.format;
        } else if ( tagName.equals(MetaConstants.COLUMN_COLUMN_EXPAND) ) {
            this.columnExpand = new MetaColumnExpand();
            resultMetaObject = columnExpand;
        }
        return resultMetaObject;
    }

    /**
     * 获取双击事件
     * @return 双击事件
     */
    public MetaBaseScript getDblClick() {
        return dblClick;
    }

    /**
     * 设置双击事件
     * @param dblClick 双击事件
     */
    public void setDblClick(MetaBaseScript dblClick) {
        this.dblClick = dblClick;
    }

    /**
     * 获取快捷键
     * @return
     */
    public MetaShortCutCollection getShortCutCollection() {
        return shortCutCollection;
    }

    /**
     * 设置快捷键
     * @param shortCutCollection
     */
    public void setShortCutCollection(MetaShortCutCollection shortCutCollection) {
        this.shortCutCollection = shortCutCollection;
    }

    /**
     * 设置单元格标识
     * @param key 标识
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * 取得单元格标识
     * @return 标识
     */
    public String getKey() {
        return this.key;
    }

    /**
     * 设置单元格名称
     * @param caption 名称
     */
    public void setCaption(String caption) {
        this.caption = caption;
    }

    /**
     * 取得单元格名称
     * @return 名称
     */
    public String getCaption() {
        return this.caption;
    }

    /**
     * 设置单元格名称全称
     * @param captionFull 名称全称
     */
    public void setCaptionFull(String captionFull) {
        this.captionFull = captionFull;
    }

    /**
     * 取得单元格名称全称
     * @return 名称全称
     */
    public String getCaptionFull() {
        return this.captionFull;
    }

    /**
     * 设置单元格英文名称
     * @param captionEn 英文名称
     */
    public void setCaptionEn(String captionEn) {
        this.captionEn = captionEn;
    }

    /**
     * 获取单元格英文名称
     * @return 英文名称
     */
    public String getCaptionEn() {
        return captionEn;
    }

    /**
     * 设置单元格英文名称全称
     * @param captionEnFull 英文名称全称
     */
    public void setCaptionEnFull(String captionEnFull) {
        this.captionEnFull = captionEnFull;
    }

    /**
     * 获取单元格英文名称全称
     * @return 英文名称全称
     */
    public String getCaptionEnFull() {
        return captionEnFull;
    }

    /**
     * 获取关键字
     * @return 关键字
     */
    public String getKeywords() {
        return keywords;
    }

    /**
     * 设置关键字
     * @param keywords 关键字
     */
    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    /**
     * 设置单元格可用性
     * @param enable 单元格可用性
     */
    public void setEnable(String enable) {
        this.enable = enable;
    }

    /**
     * 取得单元格可用性
     * @return 单元格可用性
     */
    public String getEnable() {
        return this.enable;
    }

    /**
     * 设置单元格类型
	 * @param cellType 单元格类型，取值范围见{@link ControlType}
     * @see #cellType
     */
    public void setCellType(Integer cellType) {
        this.cellType = cellType;
    }

    /**
     * 取得单元格类型
     * @return 单元格类型
     * @see #cellType
     */
    public Integer getCellType() {
        return this.cellType;
    }

    /**
     * 设置是否在合并区域
     * @param isMerged 布尔值
     */
    public void setIsMerged(Boolean isMerged) {
        this.isMerged = isMerged;
    }

    /**
     * 取得是否在合并区域
     * @return 布尔值
     */
    public Boolean isMerged() {
        return this.isMerged;
    }

    /**
     * 设置是否合并区域头
     * @param isMergedHead 布尔值
     */
    public void setIsMergedHead(Boolean isMergedHead) {
        this.isMergedHead = isMergedHead;
    }

    /**
     * 取得是否合并区域头
     * @return 布尔值
     */
    public Boolean isMergedHead() {
        return this.isMergedHead;
    }

    /**
     * 设置合并行数
     * @param mergedRowSpan 行数
     */
    public void setMergedRowSpan(Integer mergedRowSpan) {
        this.mergedRowSpan = mergedRowSpan;
    }

    /**
     * 取得是否合并行数
     * @return 行数
     */
    public Integer getMergedRowSpan() {
        return this.mergedRowSpan;
    }

    /**
     * 设置合并列数
     * @param mergedColumnSpan 列数
     */
    public void setMergedColumnSpan(Integer mergedColumnSpan) {
        this.mergedColumnSpan = mergedColumnSpan;
    }

    /**
     * 取得合并列数
     * @return 列数
     */
    public Integer getMergedColumnSpan() {
        return this.mergedColumnSpan;
    }

    /**
     * 设置分组类型
	 * @param cellGroupType 分组类型，取值范围见{@link GroupType}
     * @see #cellGroupType
     */
    public void setCellGroupType(Integer cellGroupType) {
        this.cellGroupType = cellGroupType;
    }

    /**
     * 取得分组类型
     * @return 分组类型
     * @see #cellGroupType
     */
    public Integer getCellGroupType() {
        return this.cellGroupType;
    }

    /**
     * 取得字段的标识
     * @return 标识
     */
    public String getColumnKey() {
        return this.dataBinding == null ? null : this.dataBinding.getColumnKey();
    }

    /**
     * 取得值改变事件
     * @return 值改变事件
     */
    public String getValueChanged(){
        return this.dataBinding == null ? null : this.dataBinding.getValueChanged();
    }

    /**
     * 取得值改变后事件
     * @return 值改变事件
     */
    public String getValueChangeAction(){
        return this.dataBinding == null ? null : this.dataBinding.getValueChangeAction();
    }

    /**
     * 返回数据绑定对象，如果为null则创建一个并返回
     * @return 数据绑定对象
     */
    public MetaDataBinding ensureDataBinding() {
        if( dataBinding == null ) {
            dataBinding = new MetaDataBinding();
        }
        return dataBinding;
    }

    private MetaGridCellExtendInfo ensureExtendInfo() {
        if ( extendInfo == null ) {
            extendInfo = new MetaGridCellExtendInfo();
        }
        return extendInfo;
    }

    public MetaGridCellFormat ensureCellFormat() {
        if( format == null ) {
            format = new MetaGridCellFormat();
        }
        return format;
    }

    /**
     * 设置行中的表标识
     * @param rowTableKey 表标识
     */
    public void setTableKey(String rowTableKey) {
        this.ensureExtendInfo().setRowTableKey(rowTableKey);
    }

    /**
     * 取得明细行中的表标识
     * @return 表标识
     */
    public String getTableKey() {
        return this.extendInfo == null ? null : this.extendInfo.getRowTableKey();
    }

    /**
     * 设置明细行单元格引用的元数据定义
     * @param detailRefCell 单元格元数据
     */
    public void setDetailRefCell(MetaGridCell detailRefCell) {
        this.ensureExtendInfo().setDetailRefCell(detailRefCell);
    }

    /**
     * 取得明细行单元格引用的元数据定义
     * @return 单元格元数据定义
     */
    public MetaGridCell getDetailRefCell() {
        return this.extendInfo == null ? null : this.extendInfo.getDetailRefCell();
    }

    /**
     * 设置是否选择字段
     * @param isSelect 是否选择字段
     */
    public void setSelect(Boolean isSelect) {
        this.isSelect = isSelect;
        if( isSelect!= null && isSelect ){
            this.cellType = ControlType.CHECKBOX;
        }
    }

    /**
     * 判断是否选择字段
     * @return 是否选择字段
     */
    public Boolean isSelect() {
        return this.isSelect;
    }

    /**
     * 获取选择字段是否单选
     * @return 是否单选
     */
    public Boolean singleSelect() {
        return this.singleSelect;
    }

    /**
     * 设置选择字段是否单选
     * @param singleSelect 标志
     */
    public void setSingleSelect(Boolean singleSelect) {
        this.singleSelect = singleSelect;
    }

    /**
     * 设置数据绑定对象
     * @param dataBinding 数据绑定对象
     */
    public void setDataBinding(MetaDataBinding dataBinding) {
        this.dataBinding = dataBinding;
    }

    /**
     * 取得数据绑定对象
     * @return 数据绑定对象
     */
    public MetaDataBinding getDataBinding() {
        return this.dataBinding;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaGridCell newObject = new MetaGridCell();
        newObject.setKey(key);
        newObject.setCaption(caption);
        newObject.setCaptionFull(captionFull);
        newObject.setCaptionEn(captionEn);
        newObject.setCaptionEnFull(captionEnFull);
        newObject.setCellType(cellType);
        newObject.setIsMerged(isMerged);
        newObject.setIsMergedHead(isMergedHead);
        newObject.setMergedRowSpan(mergedRowSpan);
        newObject.setMergedColumnSpan(mergedColumnSpan);
        newObject.setCellGroupType(cellGroupType);
        newObject.setProperties(properties == null ? null : properties.clone());
        newObject.setSelect(isSelect);
        newObject.setSingleSelect(singleSelect);
        newObject.setEnable(enable);
        newObject.setVisible(visible);
        newObject.setKeywords(keywords);
        newObject.setAccessControl(accessControl);
        newObject.setMerge(merge);
        newObject.setMergeGroup(mergeGroup);
        newObject.setToolTip(tip);
        newObject.setFormulaTip(formulaTip);
        newObject.setEnableDependency(enableDependency);
        newObject.setDblClick(dblClick == null ? null : (MetaBaseScript)dblClick.clone());
        newObject.setShortCutCollection(shortCutCollection == null ? null : (MetaShortCutCollection) shortCutCollection.clone());
        newObject.setCssClass(cssClass);
        newObject.setForeColor(foreColor);
        newObject.setBackColor(backColor);
        newObject.setIsVestDeleteCol(isVestDeleteCol);
        newObject.setCopyNew(copynew);

        if ( this.extendInfo != null ) {
            newObject.setTableKey(getTableKey());
            newObject.setColumnExpand(isColumnExpand());
            newObject.setExpandLevel(getExpandLevel());
            newObject.setExpandLeaf(isExpandLeaf());
            newObject.setColumnArea(getColumnArea());
        }
        newObject.setDataBinding(dataBinding == null ? null : (MetaDataBinding)dataBinding.clone());
        newObject.setHasDataBinding(hasDataBinding);

        if( crossValueMap != null ) {
            Iterator<Entry<String, MultiKeyNode>> it = crossValueMap.entrySet().iterator();
            while( it.hasNext() ) {
                Entry<String, MultiKeyNode> entry = it.next();
                newObject.addCrossValue(entry.getKey(), entry.getValue());
            }
        }

        newObject.setCustomData(customData == null ? null : (MetaCustomData)customData.clone());
        newObject.setFormat(format == null ? null : (MetaGridCellFormat) format.clone());
        newObject.setColumnExpand(columnExpand == null ? null : (MetaColumnExpand) columnExpand.clone());

        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaGridCell();
    }

    /**
     * 获取列拓展维度数据
     * @return 维度数据
     */
    public MultiKey getCrossValue() {
        return this.crossValue;
    }

    /**
     * 设置是否是列拓展单元格
     * @param isColumnExpand 标志
     */
    public void setColumnExpand(Boolean isColumnExpand) {
        this.ensureExtendInfo().setColumnExpand(isColumnExpand);
    }

    /**
     * 获取是否列拓展单元格
     * @return 标志
     */
    public Boolean isColumnExpand() {
        return this.extendInfo != null && this.extendInfo.isColumnExpand();
    }

    /**
     * 设置拓展层级
     * @param expandLevel 层级
     */
    public void setExpandLevel(Integer expandLevel) {
        this.ensureExtendInfo().setExpandLevel(expandLevel);
    }

    /**
     * 获取拓展层级
     * @return 层级
     */
    public Integer getExpandLevel() {
        return this.extendInfo == null ? -1 : this.extendInfo.getExpandLevel();
    }

    /**
     * 设置是否列扩展层次的最后一层
     * @param isExpandLeaf 标志
     */
    public void setExpandLeaf(Boolean isExpandLeaf) {
        this.ensureExtendInfo().setExpandLeaf(isExpandLeaf);
    }

    /**
     * 取得是否列扩展层次的最后一层
     * @return 是否列扩展层次的最后一层标志
     */
    public Boolean isExpandLeaf() {
        return this.extendInfo != null && this.extendInfo.isExpandLeaf();
    }

    /**
     * 设置区域编号
     * @param columnArea 区域编号
     */
    public void setColumnArea(Integer columnArea) {
        this.ensureExtendInfo().setColumnArea(columnArea);
    }

    /**
     * 取得区域编号
     * @return 区域编号
     */
    public Integer getColumnArea() {
        return this.extendInfo == null ? -1 : this.extendInfo.getColumnArea();
    }

    private MetaGridCellCalcMergeInfo ensureCalcMergeInfo() {
        if ( this.calcMergeInfo == null ) {
            this.calcMergeInfo = new MetaGridCellCalcMergeInfo();
        }
        return this.calcMergeInfo;
    }

    public void setMergeColumnExpand(boolean mergeColumnExpand) {
        this.ensureCalcMergeInfo().setMergeColumnExpand(mergeColumnExpand);
    }

    public boolean isMergeColumnExpand() {
        return this.calcMergeInfo != null && this.calcMergeInfo.isMergeColumnExpand();
    }

    public void setMergeLeftGroupColumn(boolean mergeLeftGroupColumn) {
        this.ensureCalcMergeInfo().setMergeLeftGroupColumn(mergeLeftGroupColumn);
    }

    public boolean isMergeLeftGroupColumn() {
        return this.calcMergeInfo != null && this.calcMergeInfo.isMergeLeftGroupColumn();
    }

    public void setMergeRightGroupColumn(boolean mergeRightGroupColumn) {
        this.ensureCalcMergeInfo().setMergeRightGroupColumn(mergeRightGroupColumn);
    }

    public boolean isMergeRightGroupColumn() {
        return this.calcMergeInfo != null && this.calcMergeInfo.isMergeRightGroupColumn();
    }

    public void setMergeRowGroup(boolean mergeRowGroup) {
        this.ensureCalcMergeInfo().setMergeRowGroup(mergeRowGroup);
    }

    public boolean isMergeRowGroup() {
        return this.calcMergeInfo != null && this.calcMergeInfo.isMergeRowGroup();
    }

    public void setMergeTopGroupRow(boolean mergeTopGroupRow) {
        this.ensureCalcMergeInfo().setMergeTopGroupRow(mergeTopGroupRow);
    }

    public boolean isMergeTopGroupRow() {
        return this.calcMergeInfo != null && this.calcMergeInfo.isMergeTopGroupRow();
    }

    public void setMergeBottomGroupRow(boolean mergeBottomGroupRow) {
        this.ensureCalcMergeInfo().setMergeBottomGroupRow(mergeBottomGroupRow);
    }

    public boolean isMergeBottomGroupRow() {
        return this.calcMergeInfo != null && this.calcMergeInfo.isMergeBottomGroupRow();
    }

    /**
     * 获取来自于数据源的默认值
     * @return 数据源的默认值
     */
    public String getDsDefaultValue() {
        return dsDefaultValue;
    }

    /**
     * 设置来自于数据源的默认值
     * @param dsDefaultValue 数据源的默认值
     */
    public void setDsDefaultValue(String dsDefaultValue) {
        this.dsDefaultValue = dsDefaultValue;
    }

    /**
     * 获取默认值公式
     * @return 默认值公式
     */
    public String getDefaultFormulaValue(){
        return this.dataBinding == null ? null : dataBinding.getDefaultFormulaValue();
    }

    /**
     * 获取默认值定义
     * @return 默认值定义
     */
    public String getDefaultValue(){
        return this.dataBinding == null ? null : dataBinding.getDefaultValue();
    }

    /**
     * 获取计算的值依赖
     * @return 值依赖
     */
    public String getValueDependency(){
        return this.dataBinding == null ? null : this.dataBinding.getValueDependency();
    }

    /**
     * 获取检查规则
     * @return 检查规则
     */
    public String getCheckRule(){
        return this.dataBinding == null ?  null : this.dataBinding.getCheckRule();
    }

    /**
     * 获取检查规则依赖
     * @return 检查规则依赖
     */
    public String getCheckDependency(){
        return this.dataBinding == null ? null : this.dataBinding.getCheckDependency();
    }

    /**
     * 获取错误信息描述
     * @return 错误信息描述
     */
    public String getErrorInfo(){
        return this.dataBinding == null ? null : this.dataBinding.getErrorInfo();
    }

    public String getCssClass() {
        return cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    /**
     * 获得前景色定义
     * @return 前景色定义
     */
    public String getForeColor() {
        return foreColor;
    }

    /**
     * 获得背景色定义
     * @return 背景色定义
     */
    public String getBackColor() {
        return backColor;
    }

    /**
     * 设置前景色定义
     * @param foreColor 前景色定义
     */
    public void setForeColor(String foreColor) {
        this.foreColor = foreColor;
    }

    /**
     * 设置背景色定义
     * @param backColor 背景色定义
     */
    public void setBackColor(String backColor) {
        this.backColor = backColor;
    }

    public void setHasDataBinding(boolean hasDataBinding) {
        this.hasDataBinding = hasDataBinding;
    }

    public boolean hasDataBinding() {
        return this.hasDataBinding;
    }

    public void setDimValue(MultiDimValue dimValue){
        this.dimValue = dimValue;
    }

    public MultiDimValue getDimValue() {
        return dimValue;
    }

    public void addCrossValue(String columnKey,MultiKeyNode node) {
        if( this.crossValueMap == null ) {
            this.crossValueMap = new LinkedHashMap<String,MultiKeyNode>();
        }
        this.crossValueMap.put(columnKey, node);
        if( this.crossValue == null ) {
            this.crossValue = new MultiKey();
        }
        this.crossValue.addValue(node);
    }

    public MultiKeyNode getCrossValue(String columnKey) {
        return this.crossValueMap == null ? null : this.crossValueMap.get(columnKey);
    }

    public LinkedHashMap<String, MultiKeyNode> getCrossValueMap() {
        return crossValueMap;
    }

    /**
     * 后期处理,添加依赖
     */
    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        if(this.properties != null){
            this.properties.doPostProcess(flag, callback);
        }
        if(this.rowGroup != null){
            this.rowGroup.doPostProcess(flag, callback);
        }
        if(this.customData != null){
            this.customData.doPostProcess(flag, callback);
        }
    }

    /**
     * 取得二次开发自定义描述
     * @param customData 自定义描述
     */
    public void setCustomData(MetaCustomData customData) {
        this.customData = customData;
    }

    /**
     * 取得二次开发自定义描述
     * @return 自定义描述
     */
    public MetaCustomData getCustomData() {
        return this.customData;
    }

    /**
     * 设置单元格格式
     * @param format 格式
     */
    public void setFormat(MetaGridCellFormat format) {
        this.format = format;
    }

    /**
     * 取得单元格格式
     * @return 格式
     */
    public MetaGridCellFormat getFormat() {
        return this.format;
    }

    /**
     * 设置排序类型
     * @param cellSortType 排序类型
	 * @see SortType
     */
    public void setCellSortType(Integer cellSortType) {
        this.cellSortType = cellSortType;
    }

    /**
     * 取得排序类型
     * @return 排序类型
	 * @see SortType
     */
    public Integer getCellSortType() {
        return this.cellSortType;
    }

    /**
     * 设置树形分组字典标识
     * @param cellGroupItemKey 字典标识
     */
    public void setCellGroupItemKey(String cellGroupItemKey) {
        this.cellGroupItemKey = cellGroupItemKey;
    }

    /**
     * 取得树形分组字典标识
     * @return 字典标识
     */
    public String getCellGroupItemKey() {
        return this.cellGroupItemKey;
    }

    /**
     * 设置是否作为序时簿字段
     * @param b 标志
     */
    public void setAsQuery(Boolean b) {
        this.asQuery = b;
    }

    /**
     * 取得是否序时簿字段
     * @return 标志
     */
    public Boolean isAsQuery() {
        return this.asQuery;
    }

    /**
     * 设置是否复制新增
     * @param copynew 标志
     */
    public void setCopyNew(Boolean copynew) {
        this.copynew = copynew;
    }

    /**
     * 取得是否复制新增
     * @return 标志
     */
    public Boolean isCopyNew() {
        return copynew;
    }

    /**
	 * 取得单元格可见性
	 * @return 单元格可见性
	 */
	public String getVisible() {
		return this.visible;
	}
	
	/**
	 * 设置单元格可见性
	 * @param visible 单元格可见性
	 */
	public void setVisible(String visible) {
		this.visible = visible;
	}
	
    @SuppressWarnings("unchecked")
    @Override
    public void merge(MetaGridCell metaCell) {
		this.cellType = metaCell.getCellType();
        if( this.caption == null ) {
            this.caption = metaCell.getCaption();
        }
        if( this.captionFull == null ) {
            this.captionFull = metaCell.getCaptionFull();
        }
        if( this.captionEn == null ) {
            this.captionEn = metaCell.getCaptionEn();
        }
        if( this.captionEnFull == null ) {
            this.captionEnFull = metaCell.getCaptionEnFull();
        }
        if( this.enable == null ) {
            this.enable = metaCell.getEnable();
        } else {
            extendJson.put("enble",metaCell.getEnable());
        }
        if( this.visible == null ) {
			this.visible = metaCell.getVisible();
		}
        if( this.enableDependency == null ) {
            this.enableDependency = metaCell.getEnableDependency();
        }
        if( this.isMerged == null ) {
            this.isMerged = metaCell.isMerged();
        }
        if( this.isMergedHead == null ) {
            this.isMergedHead = metaCell.isMergedHead();
        }
        if( this.merge == null ) {
            this.merge = metaCell.isMerge();
        }
        if( this.mergeGroup == null ) {
            this.mergeGroup = metaCell.isMergeGroup();
        }
        if( this.mergedRowSpan == -1 ) {
            this.mergedRowSpan = metaCell.getMergedRowSpan();
        }
        if( this.mergedColumnSpan == -1 ) {
            this.mergedColumnSpan = metaCell.getMergedColumnSpan();
        }
        if( this.cellGroupType == -1 ) {
            this.cellGroupType = metaCell.getCellGroupType();
        }
        if( this.isSelect == null ) {
            this.isSelect = metaCell.isSelect();
        }
        if( this.singleSelect == null ) {
            this.singleSelect = metaCell.singleSelect();
        }
        if( this.copynew == null ) {
            this.copynew = metaCell.isCopyNew();
        }
        if( this.tip == null ) {
            this.tip = metaCell.getToolTip();
        }
        if( this.formulaTip == null ) {
            this.formulaTip = metaCell.getFormulaTip();
        }
        MetaDataBinding metaBinding = metaCell.getDataBinding();
        if( metaBinding != null ) {
            if( this.dataBinding == null ) {
                this.dataBinding = (MetaDataBinding) metaBinding.clone();
            } else {
                this.dataBinding.merge(metaBinding);
            }
        }

        AbstractMetaObject properties = metaCell.getProperties();
        if( properties != null ) {
            if( this.properties == null ) {
                this.properties = properties.clone();
            } else {
                ((IPropertyMerger<AbstractMetaObject>)this.properties).merge(metaCell.getProperties());
            }
        }

        // 覆盖,不合并
        MetaGridCellFormat format = metaCell.getFormat();
        if( format != null && this.format == null ) {
            this.format = (MetaGridCellFormat) format.clone();
        }
        if( this.dblClick == null ) {
            this.dblClick = metaCell.getDblClick();
        }
        if( this.cssClass == null ) {
            this.cssClass = metaCell.getCssClass();
        }
        if( this.foreColor == null ) {
            this.foreColor = metaCell.getForeColor();
        }
        if( this.backColor == null ) {
            this.backColor = metaCell.getBackColor();
        }
        if( this.cellSortType == -1 ) {
            this.cellSortType = metaCell.getCellSortType();
        }
        if( this.cellGroupItemKey == null ) {
            this.cellGroupItemKey = metaCell.getCellGroupItemKey();
        }

        if( this.shortCutCollection == null ) {
            MetaShortCutCollection scc = metaCell.getShortCutCollection();
            if( scc != null ) {
                this.shortCutCollection = (MetaShortCutCollection) scc.clone();
            }
        }
    }

    @Override
    public boolean needPreLoad() {
        return true;
    }

    public static boolean isAlwaysShow(int type){
        return 	type == ControlType.LABEL ||
                type == ControlType.PRICELABEL ||
                type == ControlType.RELATIVETIME ||
                type == ControlType.BUTTON ||
                type == ControlType.BARCODER ||
                type == ControlType.CHECKBOX ||
                type == ControlType.HYPERLINK ||
                type == ControlType.IMAGE ||
                type == ControlType.VIDEOPLAYER ||
                type == ControlType.ICON ||
                type == ControlType.IMAGELIST ||
                type == ControlType.UPLOADBUTTON ||
                type == ControlType.TEXTAREA ||
                type == ControlType.RADIOBUTTON;

    }

}