package com.bokesoft.yigo.meta.form.component.control.shrinkview;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.def.ScrollType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.navigationlist.MetaNavigationList;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshControl;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;

/**
 * 顶部收缩视图组件
 * @author chenzs
 *
 */
public class MetaShrinkView extends MetaComponent {

	public static final String TAG_NAME = ControlType.STR_SHRINKVIEW;
	/** 固定部分的高度 */
	private DefSize toolBarHeight;
	/** 固定部分的背景色 */
	private String toolBarBackColor;
	/** 可滚动的根组件 */
	private MetaComponent root;
	/** 顶部可收缩部分 */
	private MetaCollapseView collapseView;
	/** 收缩后的顶部固定部分 */
	private MetaToolBarCollapse toolBarCollapse;
	/** 展开后的顶部固定部分 */
	private MetaToolBarExpand toolBarExpand;
	/** 底部操作栏 */
	private MetaOperationBar operationBar;

	/**
	 * 获取固定部分的高度
	 * @return 固定部分的高度
	 */
	public DefSize getToolBarHeight() {
		return toolBarHeight;
	}

	/**
	 * 设置固定部分的高度
	 * @param toolBarHeight 固定部分的高度
	 */
	public void setToolBarHeight(DefSize toolBarHeight) {
		this.toolBarHeight = toolBarHeight;
	}

	/**
	 * 获取固定部分的背景色
	 * @return 固定部分的背景色
	 */
	public String getToolBarBackColor() {
		return toolBarBackColor;
	}

	/**
	 * 设置固定部分的背景色
	 * @param toolBarBackColor 固定部分的背景色
	 */
	public void setToolBarBackColor(String toolBarBackColor) {
		this.toolBarBackColor = toolBarBackColor;
	}

	/**
	 * 获取可滚动的根组件
	 * @return 可滚动的根组件
	 */
	public MetaComponent getRoot() {
		return root;
	}

	/**
	 * 设置可滚动的根组件
	 * @param root 可滚动的根组件
	 */
	public void setRoot(MetaComponent root) {
		this.root = root;
	}

	/**
	 * 获取顶部可收缩部分 
	 * @return 顶部可收缩部分 
	 */
	public MetaCollapseView getCollapseView() {
		return collapseView;
	}

	/**
	 * 设置顶部可收缩部分 
	 * @param collapseView 顶部可收缩部分 
	 */
	public void setCollapseView(MetaCollapseView collapseView) {
		this.collapseView = collapseView;
	}

	/**
	 * 获取收缩后的顶部固定部分
	 * @return 收缩后的顶部固定部分
	 */
	public MetaToolBarCollapse getToolBarCollapse() {
		return toolBarCollapse;
	}

	/**
	 * 设置收缩后的顶部固定部分
	 * @param toolBarCollapse 收缩后的顶部固定部分
	 */
	public void setToolBarCollapse(MetaToolBarCollapse toolBarCollapse) {
		this.toolBarCollapse = toolBarCollapse;
	}

	/**
	 * 获取展开后的顶部固定部分
	 * @return 展开后的顶部固定部分
	 */
	public MetaToolBarExpand getToolBarExpand() {
		return toolBarExpand;
	}

	/**
	 * 设置展开后的顶部固定部分
	 * @param toolBarExpand 展开后的顶部固定部分
	 */
	public void setToolBarExpand(MetaToolBarExpand toolBarExpand) {
		this.toolBarExpand = toolBarExpand;
	}

	/**
	 * 获取底部操作栏
	 * @return 底部操作栏
	 */
	public MetaOperationBar getOperationBar() {
		return operationBar;
	}

	/**
	 * 设置底部操作栏
	 * @param operationBar 底部操作栏
	 */
	public void setOperationBar(MetaOperationBar operationBar) {
		this.operationBar = operationBar;
	}

	@Override
	public int getControlType() {
		return ControlType.SHRINKVIEW;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaShrinkView();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] { root, collapseView, toolBarCollapse, toolBarExpand, operationBar });
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if(root == null || (
				!(root instanceof MetaListView && ((MetaListView)root).getOrientation() == OrientationType.Vertical) &&
				!(root instanceof MetaEditView && ((MetaEditView)root).getOrientation() == OrientationType.Vertical) &&
				!(root instanceof MetaRefreshControl && ((MetaRefreshControl)root).getOrientation() == OrientationType.Vertical) &&
				!(root instanceof MetaGrid) && !(root instanceof MetaTableView) && 
				!(root instanceof MetaNavigationList) && !(root instanceof MetaCollectionView) &&
				!(root instanceof MetaPanel && ((MetaPanel)root).getOverflowY() == ScrollType.Scroll))){
			throw new MetaException(MetaException.SHRINK_VIEW_VERTICAL_SCROLL_COMPONENT_NOT_FOUND, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ShrinkViewVerticalScrollComponentNotFound), getKey()));
		}
		if (root != null)
			root.doPostProcess(flag, callback);
		if (collapseView != null)
			collapseView.doPostProcess(flag, callback);
		if (toolBarCollapse != null)
			toolBarCollapse.doPostProcess(flag, callback);
		if (toolBarExpand != null)
			toolBarExpand.doPostProcess(flag, callback);
		if (operationBar != null)
			operationBar.doPostProcess(flag, callback);

	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject meta = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (meta == null) {
			switch (tagName) {
			case MetaCollapseView.TAG_NAME:
				collapseView = new MetaCollapseView();
				meta = collapseView;
				break;
			case MetaToolBarCollapse.TAG_NAME:
				toolBarCollapse = new MetaToolBarCollapse();
				meta = toolBarCollapse;
				break;
			case MetaToolBarExpand.TAG_NAME:
				toolBarExpand = new MetaToolBarExpand();
				meta = toolBarExpand;
				break;
			case MetaOperationBar.TAG_NAME:
				operationBar = new MetaOperationBar();
				meta = operationBar;
				break;
			default:
				root = MetaComponentFactory.getInstance().newComponent(tagName);
				root.preProcessMetaObject(env, doc, node, flag, runType);
				meta = root;
				break;
			}
		}
		return meta;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaShrinkView metaObj = (MetaShrinkView) super.clone();
		metaObj.setToolBarHeight(toolBarHeight);
		metaObj.setToolBarBackColor(toolBarBackColor);
		metaObj.setRoot(root == null ? null : (MetaComponent) root.clone());
		metaObj.setCollapseView(collapseView == null ? null : (MetaCollapseView) collapseView.clone());
		metaObj.setToolBarExpand(toolBarExpand == null ? null : (MetaToolBarExpand) toolBarExpand.clone());
		metaObj.setToolBarCollapse(toolBarCollapse == null ? null : (MetaToolBarCollapse) toolBarCollapse.clone());
		metaObj.setOperationBar(operationBar == null ? null : (MetaOperationBar) operationBar.clone());
		return metaObj;
	}
}
