package com.bokesoft.yigo.meta.form.component.control.refresh;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaFormat;

public class MetaRefreshFooter extends MetaBaseScript {

	public static final String TAG_NAME = "RefreshFooter";

	/**
	 * 文本和背景样式
	 */
	private MetaFormat format = null;
	
	public MetaRefreshFooter(){
		super(TAG_NAME);
	}

	/**
	 * 获取文本和背景样式
	 * @return 文本和背景样式
	 */
	public MetaFormat getFormat() {
		return format;
	}

	/**
	 * 设置文本和背景样式
	 * @param format 文本和背景样式
	 */
	public void setFormat(MetaFormat format) {
		this.format = format;
	}
	
	/**
	 * 获取文本和背景样式，保证不为空
	 * @return 文本和背景样式
	 */
	public MetaFormat ensureFormat() {
		if( format == null ) {
			format = new MetaFormat();
		}
		return this.format;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { format });
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaFormat.TAG_NAME.equals(tagName)) {
			format = new MetaFormat();
			resultMetaObject = format;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRefreshFooter newObj = (MetaRefreshFooter)super.clone();
		newObj.setFormat(format == null ? null : (MetaFormat)format.clone());
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRefreshFooter();
	}

}
