package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaTimeCountDownProperties  extends AbstractMetaObject implements IPropertyMerger<MetaTimeCountDownProperties>{
	/** 显示格式 */
	private String format = null;

	/** 计时结束事件 */
	private MetaBaseScript onFinish = null;

	
	/**
	 * 显示格式
	 * @return 显示格式
	 */
	public String getFormat() {
		return format;
	}

	/**
	 * 设置显示格式
	 * @param onFinish 显示格式
	 */
	public void setFormat(String format) {
		this.format = format;
	}

	/**
	 * 获取倒数计时结束后事件
	 * @return 倒数计时结束后事件
	 */
	public MetaBaseScript getOnFinish() {
		return onFinish;
	}

	/**
	 * 设置倒数计时结束后事件
	 * @param onFinish 倒数计时结束后事件
	 */
	public void setOnFinish(MetaBaseScript onFinish) {
		this.onFinish = onFinish;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(onFinish);
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObj = null;
		if (MetaConstants.Event_OnFinish.equalsIgnoreCase(tagName)) {
			onFinish = new MetaBaseScript(MetaConstants.Event_OnFinish);
			resultMetaObj = onFinish;
		}
		return resultMetaObj;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTimeCountDownProperties newObject = (MetaTimeCountDownProperties) newInstance();
		newObject.setOnFinish(onFinish);
		newObject.setFormat(format);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTimeCountDownProperties();
	}

	@Override
	public void merge(MetaTimeCountDownProperties properties) {
		if(onFinish == null){
			onFinish = properties.getOnFinish();
		}
	}
}
