package com.bokesoft.yigo.meta.form.component.control.properties;

import java.math.BigDecimal;
import java.util.LinkedList;

import com.bokesoft.yigo.common.def.StepEditorEditType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaStepEditorProperties extends AbstractMetaObject implements IPropertyMerger<MetaStepEditorProperties>{
	/** 最小值*/
	private BigDecimal minValue = new BigDecimal(Long.MIN_VALUE);
	/** 最大值*/
	private BigDecimal maxValue = new BigDecimal(Long.MAX_VALUE);
	/** 步进值*/
	private BigDecimal step = BigDecimal.ONE;
	/** 是否禁用软键盘，针对带有输入框的组件*/
	private Boolean disableKeyboard;
	
	public static final int TYPE_RIGHTSIDE = 0;
	public static final int TYPE_BOTHSIDES = 1;
	
	/** 计步器显示样式选择 */
	private Integer showType = TYPE_BOTHSIDES;
	
	/** 编辑样式，取值参考{@link StepEditorEditType}*/
	private Integer editType = StepEditorEditType.INPUT;

	/**
	 * 获取计步器显示样式
	 * @return
	 */
	public Integer getShowType() {
		return showType;
	}

	/**
	 * 设置计步器显示样式
	 * @param showType
	 */
	public void setShowType(Integer showType) {
		this.showType = showType;
	}

	/**
	 * 获取步进值
	 * @return 步进值，默认值为1
	 */
	public BigDecimal getStep() {
		return step;
	}

	/**
	 * 设置步进值
	 * @param step 步进值
	 */
	public void setStep(BigDecimal step) {
		this.step = step;
	}

	/**
	 * 获取编辑样式
	 * @return 编辑样式，取值参考{@link StepEditorEditType}
	 */
	public Integer getEditType() {
		return editType;
	}

	/**
	 * 设置编辑样式
	 * @param editType 编辑样式，取值参考{@link StepEditorEditType}
	 */
	public void setEditType(Integer editType) {
		this.editType = editType;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	/**
	 * 设置最小值
	 * @param minValue 最小值
	 */
	public void setMinValue(BigDecimal minValue) {
		this.minValue = minValue;
	}

	/**
	 * 获取最小值
	 * @return 最小值
	 */
	public BigDecimal getMinValue() {
		return minValue;
	}

	/**
	 * 设置最大值
	 * @param maxValue 最大值
	 */
	public void setMaxValue(BigDecimal maxValue) {
		this.maxValue = maxValue;
	}

	/**
	 * 获取最大值
	 * @return 最大值
	 */
	public BigDecimal getMaxValue() {
		return maxValue;
	}

	/**
	 * 通过转换类型字符串获取样式转换类型
	 * 
	 * @param showType
	 *            字符串
	 * @return 样式转换类型
	 */
	public int parseShowType(String showType) {
		if (showType.equalsIgnoreCase("BothSides")) {
			return TYPE_BOTHSIDES;
		}
		return TYPE_RIGHTSIDE;
	}

	/**
	 * 获取样式转换类型字符串
	 * @param showType 样式转换类型
	 * @return 样式转换类型字符串
	 */
	public String getShowTypeStr(int showType) {
		if (showType == TYPE_BOTHSIDES) {
			return "BothSides";
		}
		return "RightSide";
	}
	
	/**
	 * 设置是否禁用软键盘，针对带有输入框的组件
	 * @param disableKeyboard 是否禁用软键盘
	 */
	public void setDisableKeyboard(Boolean disableKeyboard) {
		this.disableKeyboard = disableKeyboard;
	}
	
	/**
	 * 获取是否禁用软键盘，针对带有输入框的组件
	 * @return 是否禁用软键盘
	 */
	public Boolean isDisableKeyboard() {
		return disableKeyboard;
	}
	
	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaStepEditorProperties newObject = new MetaStepEditorProperties();
		newObject.setMinValue(minValue);
		newObject.setMaxValue(maxValue);
		newObject.setStep(step);
		newObject.setEditType(editType);
		newObject.setShowType(showType);
		newObject.setDisableKeyboard(disableKeyboard);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStepEditorProperties();
	}

	@Override
	public void merge(MetaStepEditorProperties properties) {
		if(minValue == null){
			minValue = properties.getMinValue();
		}
		if(maxValue == null){
			maxValue = properties.getMaxValue();
		}
		if(step == null){
			step = properties.getStep();
		}
		if(editType == -1){
			editType = properties.getEditType();
		}
		if(showType == -1) {
			showType = properties.getShowType();
		}
		if( disableKeyboard == null){
			disableKeyboard = properties.isDisableKeyboard();
		}
	}

}
