package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.def.ProgressIndicatorSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.control.progressindicator.MetaProgressItemCollection;

/**
 * 进度指示器组件的属性对象
 * @author chenzs
 */
public class MetaProgressIndicatorProperties extends AbstractMetaObject implements IPropertyMerger<MetaProgressIndicatorProperties>{
	/** 来源类型*/
	private Integer sourceType = ProgressIndicatorSourceType.ITEMS;
	/** 显示方向 */
	private Integer orientation = OrientationType.Horizontal;
	/** 完成的图片 */
	private String completedIcon;
	/** 进行中的图片 */
	private String attentionIcon;
	/** 进行中的文本的颜色 */
	private String attentionTextColor;
	/** 未完成的图片，默认图片 */
	private String defaultIcon;
	/** 未完成的线的颜色 */
	private String unCompletedLineColor;
	/** 完成的线的颜色 */
	private String completedLineColor;
	/** 未完成的文本的颜色 */
	private String unCompletedTextColor;
	/** 完成的文本的颜色 */
	private String completedTextColor;
	/** 是否倒序绘制 */
	private Boolean reverseDraw = false;
	/** 关联的数据表标识，Data类型时有效*/
	private String tableKey;
	/** 标题列标识，Data类型时有效果*/
	private String titleColumnKey;
	/** 内容列标识，Data类型时有效*/
	private String messageColumnKey;
	/** 时间列标识，Data类型时有效*/
	private String dateTimeColumnKey;
	/** 是否可以滚动*/
	private Boolean isScroll = true;

	/**
	 * 进度刻度项集合
	 */
	private MetaProgressItemCollection metaProgressItemCollection;

	/**
	 * 设置来源类型
	 * @param sourceType 来源类型，参考{@link ProgressIndicatorSourceType}
	 */
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}
	
	/**
	 * 获取来源类型
	 * @return  来源类型，参考{@link ProgressIndicatorSourceType}
	 */
	public Integer getSourceType() {
		return sourceType;
	}
	
	/**
	 * 是否倒序绘制 
	 * @return 是否倒序绘制 
	 */
	public Boolean isReverseDraw() {
		return reverseDraw;
	}

	/**
	 * 设置是否倒序绘制 
	 * @param reverseDraw 是否倒序绘制 
	 */
	public void setReverseDraw(Boolean reverseDraw) {
		this.reverseDraw = reverseDraw;
	}

	/**
	 * 获取显示方向
	 * @return 显示方向,参考{@link OrientationType}
	 */
	public Integer getOrientation() {
		return orientation;
	}

	/**
	 * 设置显示方向
	 * @param orientation 显示方向,参考{@link OrientationType}
	 */
	public void setOrientation(Integer orientation) {
		this.orientation = orientation;
	}

	/**
	 * 获取完成时节点图标
	 * @return 完成时节点图标
	 */
	public String getCompletedIcon() {
		return completedIcon;
	}

	/**
	 * 设置完成时节点图片
	 * @param completedIcon 完成时节点图片
	 */
	public void setCompletedIcon(String completedIcon) {
		this.completedIcon = completedIcon;
	}

	/**
	 * 获取进行中节点图标
	 * @return 进行中节点图标
	 */
	public String getAttentionIcon() {
		return attentionIcon;
	}

	/**
	 * 设置进行中节点图标
	 * @param attentionIcon 进行中节点图标
	 */
	public void setAttentionIcon(String attentionIcon) {
		this.attentionIcon = attentionIcon;
	}
	
	/**
	 * 获取进行中节点的文本颜色
	 * @return 进行中节点的文本颜色
	 */
	public String getAttentionTextColor() {
		return attentionTextColor;
	}
	
	/**
	 * 设置进行中节点的文本颜色
	 * @param attentionTextColor 进行中节点的文本颜色
	 */
	public void setAttentionTextColor(String attentionTextColor) {
		this.attentionTextColor = attentionTextColor;
	}

	/**
	 * 获取未完成时节点默认图标
	 * @return 未完成时节点默认图标
	 */
	public String getDefaultIcon() {
		return defaultIcon;
	}

	/**
	 * 设置未完成时节点默认图标
	 * @param defaultIcon 未完成时节点默认图标
	 */
	public void setDefaultIcon(String defaultIcon) {
		this.defaultIcon = defaultIcon;
	}

	/**
	 * 获取未完成时节点连线的颜色
	 * @return 未完成时节点连线的颜色
	 */
	public String getUnCompletedLineColor() {
		return unCompletedLineColor;
	}

	/**
	 * 设置未完成时节点连线的颜色
	 * @param unCompletedLineColor 未完成时节点连线的颜色
	 */
	public void setUnCompletedLineColor(String unCompletedLineColor) {
		this.unCompletedLineColor = unCompletedLineColor;
	}

	/**
	 * 获取完成时节点连线的颜色
	 * @return 完成时节点连线的颜色
	 */
	public String getCompletedLineColor() {
		return completedLineColor;
	}

	/**
	 * 设置完成时节点连线的颜色
	 * @param completedLineColor 完成时节点连线的颜色
	 */
	public void setCompletedLineColor(String completedLineColor) {
		this.completedLineColor = completedLineColor;
	}

	/**
	 * 设置未完成时节点文本的颜色
	 * @param unCompletedTextColor 未完成时节点文本的颜色
	 */
	public void setUnCompletedTextColor(String unCompletedTextColor) {
		this.unCompletedTextColor = unCompletedTextColor;
	}

	/**
	 * 获取未完成时节点文本的颜色
	 * @return 未完成时节点文本的颜色
	 */
	public String getUnCompletedTextColor() {
		return unCompletedTextColor;
	}

	/**
	 * 设置完成时节点文本的颜色
	 * @param completedTextColor 完成时节点文本的颜色
	 */
	public void setCompletedTextColor(String completedTextColor) {
		this.completedTextColor = completedTextColor;
	}

	/**
	 * 获取完成时节点文本的颜色
	 * @return 完成时节点文本的颜色
	 */
	public String getCompletedTextColor() {
		return completedTextColor;
	}

	/**
	 * 获取进度刻度项集合
	 * @return 进度刻度项集合
	 */
	public MetaProgressItemCollection getMetaProgressItemCollection() {
		return metaProgressItemCollection;
	}

	/**
	 * 设置进度刻度项集合
	 * @param metaProgressItemCollection 进度刻度项集合
	 */
	public void setMetaProgressItemCollection(MetaProgressItemCollection metaProgressItemCollection) {
		this.metaProgressItemCollection = metaProgressItemCollection;
	}
	
	/**
	 * 设置关联数据表标识，Data类型时有效
	 * @param tableKey 关联数据表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	/**
	 * 获取关联数据表标识，Data类型时有效
	 * @return 关联数据表标识
	 */
	public String getTableKey() {
		return tableKey;
	}

	/**
	 * 获取标题列标识，Data类型时有效果
	 * @return 标题列标识，Data类型时有效果
	 */
	public String getTitleColumnKey() {
		return titleColumnKey;
	}

	/**
	 * 设置标题列标识，Data类型时有效果
	 * @param titleColumnKey 标题列标识，Data类型时有效果
	 */
	public void setTitleColumnKey(String titleColumnKey) {
		this.titleColumnKey = titleColumnKey;
	}

	/**
	 * 获取内容列标识，Data类型时有效
	 * @return 内容列标识，Data类型时有效
	 */
	public String getMessageColumnKey() {
		return messageColumnKey;
	}

	/**
	 * 设置内容列标识，Data类型时有效
	 * @param messageColumnKey 内容列标识，Data类型时有效
	 */
	public void setMessageColumnKey(String messageColumnKey) {
		this.messageColumnKey = messageColumnKey;
	}

	/**
	 * 获取时间列标识，Data类型时有效
	 * @return 时间列标识，Data类型时有效
	 */
	public String getDateTimeColumnKey() {
		return dateTimeColumnKey;
	}

	/**
	 * 设置时间列标识，Data类型时有效
	 * @param dateTimeColumnKey 时间列标识，Data类型时有效
	 */
	public void setDateTimeColumnKey(String dateTimeColumnKey) {
		this.dateTimeColumnKey = dateTimeColumnKey;
	}

	/**
	 * 是否可滚动，默认为true
	 * @return 是否可滚动
	 */
	public Boolean isScroll() {
		return isScroll;
	}

	/**
	 * 设置是否可滚动，默认为true
	 * @param isScroll 是否可滚动
	 */
	public void setScroll(Boolean isScroll) {
		this.isScroll = isScroll;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[]{metaProgressItemCollection});
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if (tagName.equalsIgnoreCase(MetaProgressItemCollection.TAG_NAME)) {
			metaProgressItemCollection = new MetaProgressItemCollection();
			metaObject = metaProgressItemCollection;
		}
		return metaObject;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback); 
		if (unCompletedLineColor == null || unCompletedLineColor.isEmpty() ||
				completedLineColor == null || completedLineColor.isEmpty() ||
				completedTextColor == null || completedTextColor.isEmpty() ||
				unCompletedTextColor == null || unCompletedTextColor.isEmpty()) {
			//TODO 加报错文本
//			throw new MetaException(MetaException.PROGRESS_INDICATOR_ALL_COLOR_CAN_NOT_BE_EMPTY, "new ErrorInfo(R.string.ProgressIndicatorAllColorCanNotBeEmpty, key)");
		}
	}

	@Override
	public AbstractMetaObject clone() {
		MetaProgressIndicatorProperties newObj = (MetaProgressIndicatorProperties) newInstance();
		newObj.setSourceType(sourceType);
		newObj.setCompletedIcon(completedIcon);
		newObj.setAttentionIcon(attentionIcon);
		newObj.setAttentionTextColor(attentionTextColor);
		newObj.setDefaultIcon(defaultIcon);
		newObj.setCompletedLineColor(completedLineColor);
		newObj.setCompletedTextColor(completedTextColor);
		newObj.setUnCompletedLineColor(unCompletedLineColor);
		newObj.setUnCompletedTextColor(unCompletedTextColor);
		newObj.setOrientation(orientation);
		newObj.setMetaProgressItemCollection(metaProgressItemCollection == null ? null
				: (MetaProgressItemCollection) metaProgressItemCollection.clone());
		newObj.setTableKey(tableKey);
		newObj.setTitleColumnKey(titleColumnKey);
		newObj.setMessageColumnKey(messageColumnKey);
		newObj.setDateTimeColumnKey(dateTimeColumnKey);
		newObj.setScroll(isScroll);
		newObj.setReverseDraw(reverseDraw);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaProgressIndicatorProperties();
	}

	@Override
	public void merge(MetaProgressIndicatorProperties properties) {
		if(sourceType == -1){
			sourceType = properties.getSourceType();
		}
		if(completedIcon == null){
			completedIcon = properties.getCompletedIcon();
		}
		if(attentionIcon == null){
			attentionIcon = properties.getAttentionIcon();
		}
		if(attentionTextColor == null){
			attentionTextColor = properties.getAttentionTextColor();
		}
		if(defaultIcon == null){
			defaultIcon = properties.getDefaultIcon();
		}
		if(completedLineColor == null){
			completedLineColor = properties.getCompletedLineColor();
		}
		if(completedTextColor == null){
			completedTextColor = properties.getCompletedTextColor();
		}
		if(unCompletedLineColor == null){
			unCompletedLineColor = properties.getUnCompletedLineColor();
		}
		if(unCompletedTextColor == null){
			unCompletedTextColor = properties.getUnCompletedTextColor();
		}
		if(orientation == -1){
			orientation = properties.getOrientation();
		}
		if(tableKey == null){
			tableKey = properties.getTableKey();
		}
		if(titleColumnKey == null){
			titleColumnKey = properties.getTitleColumnKey();
		}
		if(messageColumnKey == null){
			messageColumnKey = properties.getMessageColumnKey();
		}
		if(dateTimeColumnKey == null){
			dateTimeColumnKey = properties.getDateTimeColumnKey();
		}
		if(isScroll == null){
			isScroll = properties.isScroll();
		}
		if(reverseDraw == null){
			reverseDraw = properties.isReverseDraw();
		}
		if(metaProgressItemCollection == null){
			metaProgressItemCollection = properties.getMetaProgressItemCollection();
		}
	}
}
