package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.RoundingMode;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaNumberEditorProperties extends AbstractMetaObject implements IPropertyMerger<MetaNumberEditorProperties>{
	/** 数值精度*/
	private Integer precision = 16;

	/** 小数位位数*/
	private Integer scale = 2;
	
	/** 为了兼容保留这个属性,设计器不能配置*/
	private Boolean integerValue = false;

	/** 是否使用组分割，比如千分位 */
	private Boolean isUseGroupingSeparator = true;
	
	/** 内容为空的时候的提示文本 */
	private String promptText = "";

    /** 光标进入默认全选。 */
	private Boolean selectOnFocus = true;
	
	/** 移动端selectOnFocus默认值和平台不一致,特加此属性供其使用*/
	private Boolean mobileSelectOnFocus = false;
	
	/** 四舍五入规则,-1表示未定义*/
	private Integer roundingMode = RoundingMode.HALF_UP;
	
	/** 是否显示零值,默认不显示*/
	private Boolean showZero = false;
	
	/** 0值字符串 ,只对表格有效*/
	private String zeroString = "";
	
	/** 负数前景色,只对表格有效 */
	private String negtiveForeColor = "";
	
	/** 文本显示格式化类型，比如带上百分比号，比如带上美元符号等等*/
	private Integer formatStyle = -1;
	
	/** 修改软键盘的回车键类型*/
	private Integer imeOptions = -1;
	
	/** 焦点获取事件*/
	private MetaBaseScript onFocus = null;
	
	/** 是否去除末尾多余的0 */
	private Boolean stripTrailingZeros = false;
	/** 是否禁用软键盘，针对带有输入框的组件*/
	private Boolean disableKeyboard;
	
	/**后缀字符*/
	private String suffix = "";
	
	/**前缀*/
	private String prefix = "";
	
	/** 表达式显示值 */
	private String formulaText = "";
	
	/**是否显示空值， 默认不显示*/
	private Boolean allowNull = false;
	
	public MetaNumberEditorProperties() {
		super();
	}
	
	/**
	 * 设置舍入规则
	 * @param mode 舍入规则
	 */
	public void setRoundingMode(Integer mode){
		this.roundingMode = mode;
	}
	
	/**
	 * 获取舍入规则
	 * @return 舍入规则
	 */
	public Integer getRoundingMode(){
		return this.roundingMode;
	}
	
	/**
	 * 获取是否整型
	 * @return 标志
	 */
	public Boolean integerValue() {
		return integerValue;
	}

	/**
	 * 设置是否整型
	 * @param integerValue 标志
	 */
	public void setIntegerValue(Boolean integerValue) {
		this.integerValue = integerValue;
	}
	
	/**
	 * 取得是否获得焦点时默认全选
	 * @return 标志
	 */
	public Boolean isSelectOnFocus() {
		return this.selectOnFocus;
	}

	/**
	 * 设置获得焦点时默认全选标志
	 * @param selectOnFocus 标志
	 */
	public void setSelectOnFocus(Boolean selectOnFocus) {
		this.selectOnFocus = selectOnFocus;
	}
	
	/**
	 * 移动端特有属性-光标进入是否默认全选
	 * @return
	 */
	public Boolean isMobileSelectOnFocus() {
		return mobileSelectOnFocus;
	}

	/**
	 * 移动端特有属性-光标进入是否默认全选
	 * @param mobileSelectOnFocus
	 */
	public void setMobileSelectOnFocus(Boolean mobileSelectOnFocus) {
		this.mobileSelectOnFocus = mobileSelectOnFocus;
	}

	/**
	 * 取得是否显示零值
	 * @return 是否显示零值标志
	 */
	public Boolean isShowZero() {
		return this.showZero;
	}

	/**
	 * 设置是否显示零值
	 * @param showZero 是否显示零值标志
	 */
	public void setShowZero(Boolean showZero) {
		this.showZero = showZero;
	}

	/**
	 * 设置数值精度
	 * 
	 * @param precision
	 *            精度
	 */
	public void setPrecision(Integer precision) {
		this.precision = precision;
	}

	/**
	 * 获取数值精度
	 * 
	 * @return 精度
	 */
	public Integer getPrecision() {
		return this.precision;
	}

	/**
	 * 设置小数位位数
	 * 
	 * @param scale
	 *            小数位位数
	 */
	public void setScale(Integer scale) {
		this.scale = scale;
	}

	/**
	 * 获取小数位位数
	 * 
	 * @return 小数位位数
	 */
	public Integer getScale() {
		return this.scale;
	}

	/**
	 * 设置是否使用组分割，比如千分位
	 * 
	 * @param use
	 *            是否使用组分割
	 */
	public void setUseGroupingSeparator(Boolean use) {
		this.isUseGroupingSeparator = use;
	}

	/**
	 * 获取是否使用组分割，比如千分位
	 * 
	 * @return 是否使用组分割
	 */
	public Boolean isUseGroupingSeparator() {
		return this.isUseGroupingSeparator;
	}
	
	/**
	 * 设置提示文本
	 * @param promptText 提示文本
	 */
	public void setPromptText(String promptText) {
		this.promptText = promptText;
	}
	
	/**
	 * 取得提示文本
	 * @return 提示文本
	 */
	public String getPromptText() {
		return this.promptText;
	}
	
	/**
	 * 设置0值字符串
	 * @param zeroString 0值字符串
	 */
	public void setZeroString(String zeroString) {
		this.zeroString = zeroString;
	}
	
	/**
	 * 取得0值字符串
	 * @return 0值字符串
	 */
	public String getZeroString() {
		return this.zeroString;
	}
	
	/**
	 * 设置负值前景色
	 * @param negtiveForeColor 负值前景色
	 */
	public void setNegtiveForeColor(String negtiveForeColor) {
		this.negtiveForeColor = negtiveForeColor;
	}
	
	/**
	 * 取得负值前景色
	 * @return 负值前景色
	 */
	public String getNegtiveForeColor() {
		return this.negtiveForeColor;
	}

	public Integer getFormatStyle() {
		return formatStyle;
	}

	public void setFormatStyle(Integer formatStyle) {
		this.formatStyle = formatStyle;
	}

	public Integer getImeOptions() {
		return imeOptions;
	}

	public void setImeOptions(Integer imeOptions) {
		this.imeOptions = imeOptions;
	}

	public MetaBaseScript getOnFocus() {
		return onFocus;
	}

	public void setOnFocus(MetaBaseScript onFocus) {
		this.onFocus = onFocus;
	}
	
	/**
	 * 获取是否去尾0
	 * 
	 * @return 是否去尾0
	 */
	public Boolean getStripTrailingZeros() {
		return this.stripTrailingZeros;
	}

	/**
	 * 设置是否去尾0
	 * 
	 * @param stripTrailingZeros 是否去尾0
	 */
	public void setStripTrailingZeros(Boolean stripTrailingZeros) {
		this.stripTrailingZeros = stripTrailingZeros;
	}

	/**
	 * 设置是否禁用软键盘，针对带有输入框的组件
	 * @param disableKeyboard 是否禁用软键盘
	 */
	public void setDisableKeyboard(Boolean disableKeyboard) {
		this.disableKeyboard = disableKeyboard;
	}
	
	/**
	 * 获取是否禁用软键盘，针对带有输入框的组件
	 * @return 是否禁用软键盘
	 */
	public Boolean isDisableKeyboard() {
		return disableKeyboard;
	}
	
	public String getSuffix() {
		return suffix;
	}

	public void setSuffix(String suffix) {
		this.suffix = suffix;
	}

	public String getPrefix() {
		return prefix;
	}

	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	public String getFormulaText() {
		return formulaText;
	}

	public void setFormulaText(String formulaText) {
		this.formulaText = formulaText;
	}
	
	/**
	 * 获取是否显示空
	 * @return
	 */
	public Boolean getAllowNull() {
		return this.allowNull;
	}

	/**
	 * 设置是否显示空
	 * @param allowNull
	 */
	public void setAllowNull(Boolean allowNull) {
		this.allowNull = allowNull;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(onFocus);
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaConstants.Event_OnFocus.equals(tagName) ) {
			this.onFocus = new MetaBaseScript(MetaConstants.Event_OnFocus);
			resultMetaObject = this.onFocus;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaNumberEditorProperties newObject = new MetaNumberEditorProperties();
		newObject.setPrecision(precision);
		newObject.setScale(scale);
		newObject.setUseGroupingSeparator(isUseGroupingSeparator);
		newObject.setPromptText(promptText);
		newObject.setSelectOnFocus(selectOnFocus);
		newObject.setRoundingMode(roundingMode);
		newObject.setZeroString(zeroString);
		newObject.setNegtiveForeColor(negtiveForeColor);
		newObject.setShowZero(showZero);
		newObject.setFormatStyle(formatStyle);
		newObject.setImeOptions(imeOptions);
		newObject.setOnFocus(onFocus == null ? null : (MetaBaseScript)onFocus.clone());
		newObject.setStripTrailingZeros(stripTrailingZeros);
		newObject.setIntegerValue(integerValue);
		newObject.setDisableKeyboard(disableKeyboard);
		newObject.setSuffix(suffix);
		newObject.setPrefix(prefix);
		newObject.setFormulaText(formulaText);
		return newObject;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		if (this.integerValue != null && Boolean.TRUE.compareTo(this.integerValue) == 0) { // 兼容2.0.3 以前版本无数据源字段处理
			this.scale = 0;
		}
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNumberEditorProperties();
	}

	@Override
	public void merge(MetaNumberEditorProperties properties) {
		if( this.precision == null ) {
			this.precision = properties.getPrecision();
		}
		if( this.scale == null ) {
			this.scale = properties.getScale();
		}
		if( this.integerValue == null ) {
			this.integerValue = properties.integerValue();
		}
		if( this.isUseGroupingSeparator == null ) {
			this.isUseGroupingSeparator = properties.isUseGroupingSeparator();
		}
		if( this.promptText == null ) {
			this.promptText = properties.getPromptText();
		}
		if( this.selectOnFocus == null ) {
			this.selectOnFocus = properties.isSelectOnFocus();
		}
		if( this.roundingMode == -1 ) {
			this.roundingMode = properties.getRoundingMode();
		}
		if( this.showZero == null ) {
			this.showZero = properties.isShowZero();
		}
		if( this.zeroString == null ) {
			this.zeroString = properties.getZeroString();
		}
		if( this.negtiveForeColor == null ) {
			this.negtiveForeColor = properties.getNegtiveForeColor();
		}
		if( this.stripTrailingZeros == null) {
			this.stripTrailingZeros = properties.getStripTrailingZeros();
		}
		if( this.disableKeyboard == null){
			this.disableKeyboard = properties.isDisableKeyboard();
		}
		if( this.suffix == null){
			this.suffix = properties.getSuffix();
		}
		if( this.prefix == null){
			this.prefix = properties.getPrefix();
		}
		if( this.formulaText == null){
			this.formulaText = properties.getFormulaText();
		}
	}
}
