package com.bokesoft.yigo.meta.form.component.control.moduleeditor;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 模块编辑器的固定项
 * 
 * @author chenzs
 *
 */
public class MetaModuleItem extends KeyPairMetaObject {

	public static final String TAG_NAME = "ModuleItem";

	/** 模块项目的标识 */
	private String key = "";
	/** 模块项目的名称 */
	private String caption = "";
	/** 模块项目的图标 */
	private String image = "";
	/** 模块项目的分组值 */
	private String groupValue = "";
	/** 模块项目的分组名称 */
	private String groupCaption = "";

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 获取模块项目的名称
	 * 
	 * @return 模块项目的名称
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 设置模块项目的名称
	 * 
	 * @param caption 模块项目的名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 获取模块项目的图标
	 * 
	 * @return 模块项目的图标
	 */
	public String getImage() {
		return image;
	}

	/**
	 * 设置模块项目的图标
	 * 
	 * @param image 模块项目的图标
	 */
	public void setImage(String image) {
		this.image = image;
	}

	/**
	 * 获取模块项目的分组值
	 * 
	 * @return 模块项目的分组值
	 */
	public String getGroupValue() {
		return groupValue;
	}

	/**
	 * 设置模块项目的分组值
	 * 
	 * @param groupValue 模块项目的分组值
	 */
	public void setGroupValue(String groupValue) {
		this.groupValue = groupValue;
	}

	/**
	 * 获取模块项目的分组名称
	 * 
	 * @return 模块项目的分组名称
	 */
	public String getGroupCaption() {
		return groupCaption;
	}

	/**
	 * 设置模块项目的分组名称
	 * 
	 * @param groupCaption 模块项目的分组名称
	 */
	public void setGroupCaption(String groupCaption) {
		this.groupCaption = groupCaption;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject obj = null;
		return obj;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaModuleItem meta = new MetaModuleItem();
		meta.setKey(key);
		meta.setCaption(caption);
		meta.setImage(image);
		meta.setGroupValue(groupValue);
		meta.setGroupCaption(groupCaption);
		return meta;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaModuleItem();
	}
}
