package com.bokesoft.yigo.meta.form.component.control.gantt;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 甘特图的关系绑定的数据来源
 */
public class MetaRelationship extends AbstractMetaObject {

	public static final String TAG_NAME = "Relationship";

	/** 关系表名称 */
	private String tableKey = "";

	/** 前任 */
	private String predecessor = "";

	/** 继任者 */
	private String successor = "";

	/** 关系类型 */
	private String type = "";

	/**
	 * 获取关系表
	 * @return
	 */
	public String getTableKey() {
		return tableKey;
	}

	/**
	 *	设置关系表
	 * @param tableKey
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	/**
	 * 获取前任
	 * 
	 * @return
	 */
	public String getPredecessor() {
		return predecessor;
	}

	/**
	 * 设置前任
	 * 
	 * @param predecessor
	 */
	public void setPredecessor(String predecessor) {
		this.predecessor = predecessor;
	}

	/**
	 * 获取继任
	 * 
	 * @return
	 */
	public String getSuccessor() {
		return successor;
	}

	/**
	 * 设置继任
	 * 
	 * @param successor
	 */
	public void setSuccessor(String successor) {
		this.successor = successor;
	}

	/**
	 * 获取关系类型
	 * 
	 * @return
	 */
	public String getType() {
		return type;
	}

	/**
	 * 设置关系类型
	 * 
	 * @param type
	 */
	public void setType(String type) {
		this.type = type;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRelationship newObject = new MetaRelationship();
		newObject.setPredecessor(this.predecessor);
		newObject.setSuccessor(this.successor);
		newObject.setType(this.type);

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRelationship();
	}

}
