package com.bokesoft.yigo.meta.form.component.control.gantt;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 甘特图图形部分设置
 */
public class MetaGanttRowSetting extends AbstractMetaObject {

	public static final String TAG_NAME = "GanttRowSetting";

	/** 关系表名称 */
	private String relationships = "";
	
	/** 允许拖拽调整图形 */
	private String dragProgress = "";

	/** 关系数据来源 */
	private MetaRelationship relationship = null;

	/** 图形格式和数据来源 */
	private MetaBaseShape baseShape = null;

	/**
	 * 设置关系表名称
	 * 
	 * @param relationships
	 */
	public void setRelationships(String relationships) {
		this.relationships = relationships;
	}

	/**
	 * 获取关系表名称
	 * 
	 * @return
	 */
	public String getRelationships() {
		return this.relationships;
	}

	/**
	 * 获取关系数据
	 * 
	 * @return
	 */
	public MetaRelationship getRelationship() {
		return relationship;
	}

	/**
	 * 设置关系数据
	 * 
	 * @param relationship
	 */
	public void setRelationship(MetaRelationship relationship) {
		this.relationship = relationship;
	}
	
	/**
	 * 获取是否允许拖拽
	 * 
	 * @return
	 */
	public String getDragProgress() {
		return dragProgress;
	}

	/**
	 * 设置是否允许拖拽
	 * 
	 * @param dragProgress
	 */
	public void setDragProgress(String dragProgress) {
		this.dragProgress = dragProgress;
	}

	/**
	 * 获取图形数据
	 * 
	 * @return
	 */
	public MetaBaseShape getBaseShape() {
		return baseShape;
	}

	/**
	 * 设置图形数据
	 * 
	 * @param baseShape
	 */
	public void setBaseShape(MetaBaseShape baseShape) {
		this.baseShape = baseShape;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(baseShape);
		list.add(relationship);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject metaObj = null;
		if (MetaBaseShape.TAG_NAME.equals(tagName)) {
			this.baseShape = new MetaBaseShape();
			metaObj = this.baseShape;
		} else if (MetaRelationship.TAG_NAME.equals(tagName)) {
			this.relationship = new MetaRelationship();
			metaObj = this.relationship;
		}

		return metaObj;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGanttRowSetting newObject = new MetaGanttRowSetting();
		newObject.setRelationships(this.relationships);
		newObject.setDragProgress(this.dragProgress);
		newObject.setBaseShape(this.baseShape == null ? null : (MetaBaseShape) this.baseShape.clone());
		newObject.setRelationship(this.relationship == null ? null : (MetaRelationship) this.relationship.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGanttRowSetting();
	}

}
