package com.bokesoft.yigo.meta.form.component.control.collectionview;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

/**
 * 表视图组件的行配置对象
 * @author my
 *
 */
public class MetaCollectionViewRow extends MetaComponent {
	/** 根组件 */
	private MetaComponent root = null;
	/** 行点击事件 */
	private MetaBaseScript rowClick = null;
	/** 行双击事件 */
	private MetaBaseScript rowDblClick = null;
	/** 焦点行改变事件 */
	private MetaBaseScript focusRowChanged = null;
	/**
	 * 间隔样式，目前支持值：""（默认）、"Solid"（实线，四周都有）、"None"（无边框）、 "None Solid"
	 * （前一个代表上下，后一个代表左右）、 "Solid None None Solid"（四个按方位，上右下左来设置）。
	 */
	private String separatorStyle = "";
	/** 边框圆角大小,只对solid有效 */
	private Integer separatorRadius = -1;
	/** 间隔颜色 */
	private String separatorColor = "";
	/** 间隔距离左边界的距离 */
	private DefSize separatorOffset = null;
	/** 顶边界 */
	private String topMargin = ""; 
	/** 选中颜色 */
	private String selectColor = "";
	/** 高亮颜色 */
	private String highlightColor = "";
	/** 背景颜色 */
	private String backColor = "";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] { root, rowClick, rowDblClick, focusRowChanged });
	}

	public static final String TAG_NAME = "CollectionViewRow";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 设置行点击事件
	 * 
	 * @param rowClick
	 *            定义
	 */
	public void setRowClick(MetaBaseScript rowClick) {
		this.rowClick = rowClick;
	}

	/**
	 * 取得行击点事件
	 * 
	 * @return 定义
	 */
	public MetaBaseScript getRowClick() {
		return this.rowClick;
	}

	/**
	 * 设置行双击事件
	 * @param rowDblClick 行双击事件
	 */
	public void setRowDblClick(MetaBaseScript rowDblClick) {
		this.rowDblClick = rowDblClick;
	}

	/**
	 * 获取行双击事件
	 * @return 行双击事件
	 */
	public MetaBaseScript getRowDblClick() {
		return rowDblClick;
	}

	/**
	 * 设置行焦点改变事件
	 * @param focusRowChanged 行焦点改变事件
	 */
	public void setFocusRowChanged(MetaBaseScript focusRowChanged) {
		this.focusRowChanged = focusRowChanged;
	}

	/**
	 * 获取行焦点改变事件
	 * @return 行焦点改变事件
	 */
	public MetaBaseScript getFocusRowChanged() {
		return focusRowChanged;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if (root != null) {
			root.doPostProcess(flag, callback);
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject;
		if (MetaConstants.Event_RowClick.equals(tagName)) {
			rowClick = new MetaBaseScript(MetaConstants.Event_RowClick);
			resultMetaObject = rowClick;
		} else if (MetaConstants.Event_RowDblClick.equals(tagName)) {
			rowDblClick = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			resultMetaObject = rowDblClick;
		} else if (MetaConstants.Event_FocusRowChanged.equals(tagName)) {
			focusRowChanged = new MetaBaseScript(MetaConstants.Event_FocusRowChanged);
			resultMetaObject = focusRowChanged;
		} else {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
			if (resultMetaObject == null) {
				root = MetaComponentFactory.getInstance().newComponent(tagName);
				root.preProcessMetaObject(env, doc, node, flag, runType);
				resultMetaObject = root;
			}
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCollectionViewRow newObject = (MetaCollectionViewRow) super.clone();
		newObject.setSeparatorStyle(separatorStyle);
		newObject.setSeparatorColor(separatorColor);
		newObject.setSeparatorRadius(separatorRadius);
		newObject.setSeparatorOffset(separatorOffset);
		newObject.setTopMargin(topMargin);
		newObject.setSelectColor(selectColor);
		newObject.setHighlightColor(highlightColor);
		newObject.setBackColor(backColor);
		newObject.setRoot(root == null ? null : (MetaComponent) root.clone());
		newObject.setRowClick(rowClick == null ? null : (MetaBaseScript) rowClick.clone());
		newObject.setRowDblClick(rowDblClick == null ? null : (MetaBaseScript) rowDblClick.clone());
		newObject.setFocusRowChanged(focusRowChanged == null ? null : (MetaBaseScript) focusRowChanged.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCollectionViewRow();
	}

	/**
	 * 设置间隔距离左边界的距离
	 * @param separatorOffset 间隔距离左边界的距离
	 */
	public void setSeparatorOffset(DefSize separatorOffset) {
		this.separatorOffset = separatorOffset;
	}
	
	/**
	 * 获取间隔距离左边界的距离
	 * @return 间隔距离左边界的距离
	 */
	public DefSize getSeparatorOffset() {
		return separatorOffset;
	}

	/**
	 * 设置根组件
	 * 
	 * @param root
	 *            根组件
	 */
	public void setRoot(MetaComponent root) {
		this.root = root;
	}

	/**
	 * 取得根组件
	 * 
	 * @return 根组件
	 */
	public MetaComponent getRoot() {
		return this.root;
	}

	/**
	 * 获取间隔样式
	 * 
	 * @return 间隔样式
	 */
	public String getSeparatorStyle() {
		return separatorStyle;
	}

	/**
	 * 设置间隔样式
	 * 
	 * @param separatorStyle
	 *            间隔样式
	 */
	public void setSeparatorStyle(String separatorStyle) {
		this.separatorStyle = separatorStyle;
	}

	/**
	 * 取得边框圆角大小
	 * @return 大小
	 */
	public Integer getSeparatorRadius() {
		return this.separatorRadius;
	}
	
	/**
	 * 设置边框圆角大小
	 * @param separatorRadius 大小
	 */
	public void setSeparatorRadius(Integer separatorRadius) {
		this.separatorRadius = separatorRadius;
	}

	/**
	 * 获取间隔颜色
	 * 
	 * @return 间隔颜色
	 */
	public String getSeparatorColor() {
		return separatorColor;
	}

	/**
	 * 设置间隔颜色
	 * 
	 * @param separatorColor
	 *            间隔颜色
	 */
	public void setSeparatorColor(String separatorColor) {
		this.separatorColor = separatorColor;
	}

	/**
	 * 获取顶边界
	 * 
	 * @return 顶边界
	 */
	public String getTopMargin() {
		return topMargin;
	}

	/**
	 * 设置顶边界
	 * 
	 * @param topMargin
	 *            顶边界
	 */
	public void setTopMargin(String topMargin) {
		this.topMargin = topMargin;
	}

	/**
	 * 设置选中颜色
	 * 
	 * @param selectColor
	 *            选中颜色
	 */
	public void setSelectColor(String selectColor) {
		this.selectColor = selectColor;
	}

	/**
	 * 获取选中颜色
	 * 
	 * @return 选中颜色
	 */
	public String getSelectColor() {
		return selectColor;
	}

	/**
	 * 设置高亮颜色
	 * 
	 * @param highlightColor 高亮颜色
	 */
	public void setHighlightColor(String highlightColor) {
		this.highlightColor = highlightColor;
	}

	/**
	 * 获取高亮颜色
	 * 
	 * @return 高亮颜色
	 */
	public String getHighlightColor() {
		return highlightColor;
	}

	/**
	 * 设置背景颜色
	 * 
	 * @param backColor
	 *            背景颜色
	 */

	public void setBackColor(String backColor) {
		this.backColor = backColor;
	}

	/**
	 * 获取背景颜色
	 * 
	 * @return 背景颜色
	 */
	public String getBackColor() {
		return backColor;
	}

	@Override
	public int getControlType() {
		return ControlType.OTHER;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
}
