package com.bokesoft.yigo.meta.form.component.control.collectionview;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRowCollection;

/**
 * 表视图配置对象
 */

public class MetaCollectionView extends MetaComponent {
	public static final String TAG_NAME = ControlType.STR_COLLECTIONVIEW;

	/** 行集合 */
	private MetaCollectionViewRowCollection rows = null;

	@Override
	public int getControlType() {
		return ControlType.COLLECTIONVIEW;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new Object[] { rows });
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public MetaCollectionView newInstance() {
		return new MetaCollectionView();
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( resultMetaObject == null ) {
			if ( MetaCollectionViewRowCollection.TAG_NAME.equals(tagName) ) {
				this.rows = new MetaCollectionViewRowCollection();
				resultMetaObject = this.rows;
			}
		}
		return resultMetaObject;
	}
	
	public MetaCollectionViewRowCollection getRows() {
		return rows;
	}
	
	public void setRows(MetaCollectionViewRowCollection rows) {
		this.rows = rows;
	}

	@Override
	public MetaCollectionView clone() {
		MetaCollectionView newObject = (MetaCollectionView) super.clone();
		newObject.setRows(rows == null ? null: (MetaCollectionViewRowCollection)rows.clone());
		return newObject;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if (rows != null) { 
			for (int i = 0, size = rows.size(); i < size; i++) {
				MetaCollectionViewRow element = rows.get(i);
				element.doPostProcess(flag, callback);
			}
		}
	}
	/**
	 * 构造方法，初始化items
	 */
	public MetaCollectionView() {
		super();
		rows = new MetaCollectionViewRowCollection();
	}
}
