package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSwitchProperties;

/**
 * 移动端组件-开关控件
 * @author chenzs
 *
 */
public class MetaSwitch extends MetaComponent{

	public static final String TAG_NAME = ControlType.STR_SWITCH;
	
	/** 属性配置对象*/
	private MetaSwitchProperties properties = new MetaSwitchProperties();
	
	@Override
	public int getControlType() {
		return ControlType.SWITCH;
	}

	/**
	 * 设置属性配置对象
	 * @param properties 属性配置对象
	 */
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaSwitchProperties) properties;
	}
	
	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSwitch();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSwitch newObject = (MetaSwitch)super.clone();
		newObject.setProperties((MetaSwitchProperties)properties.clone());
		return newObject;
	}
}
