package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSubFormProperties;

public class MetaSubForm extends MetaComponent {
	private MetaSubFormProperties properties = new MetaSubFormProperties();
	public MetaSubForm() {
		super();
	}
	
	@Override
	public int getControlType() {
		return ControlType.SUBFORM;
	}
	
	/**
	 * 设置表单标识
	 * @param formKey 表单标识
	 */
	public void setFormKey(String formKey) {
		this.properties.setFormKey(formKey);
	}
	
	/**
	 * 取得表单标识
	 * @return 表单标识
	 */
	public String getFormKey() {
		return this.properties.getFormKey();
	}
	
	/**
	 * 设置属性对象
	 * @param properties 属性对象
	 */
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaSubFormProperties) properties;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	public static final String TAG_NAME = ControlType.STR_SUBFORM;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSubForm();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSubForm newObject = (MetaSubForm)super.clone();
		newObject.setProperties((MetaSubFormProperties)properties.clone());
		return newObject;
	}
}
